/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.blobstore;

import io.skylite.common.CheckedBiConsumer;
import io.skylite.common.action.ActionListener;
import io.skylite.common.blobstore.BlobContainer;
import io.skylite.common.blobstore.BlobMetadata;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.common.blobstore.DeleteResult;
import io.skylite.common.crypto.CryptoHandler;
import io.skylite.common.crypto.DecryptedRangedStreamProvider;
import io.skylite.common.crypto.EncryptedHeaderContentSupplier;
import io.skylite.common.io.InputStreamContainer;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.blobstore.EncryptedBlobMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EncryptedBlobContainer<T, U>
implements BlobContainer {
    private final BlobContainer blobContainer;
    private final CryptoHandler<T, U> cryptoHandler;

    public EncryptedBlobContainer(BlobContainer blobContainer, CryptoHandler<T, U> cryptoHandler) {
        this.blobContainer = blobContainer;
        this.cryptoHandler = cryptoHandler;
    }

    public BlobPath path() {
        return this.blobContainer.path();
    }

    public boolean blobExists(String blobName) throws IOException {
        return this.blobContainer.blobExists(blobName);
    }

    public InputStream readBlob(String blobName) throws IOException {
        InputStream inputStream = this.blobContainer.readBlob(blobName);
        return this.cryptoHandler.createDecryptingStream(inputStream);
    }

    EncryptedHeaderContentSupplier getEncryptedHeaderContentSupplier(String blobName) {
        return (start, end) -> {
            byte[] buffer;
            int length = (int)(end - start + 1L);
            try (InputStream inputStream = this.blobContainer.readBlob(blobName, start, (long)length);){
                buffer = new byte[length];
                inputStream.readNBytes(buffer, (int)start, buffer.length);
            }
            return buffer;
        };
    }

    public InputStream readBlob(String blobName, long position, long length) throws IOException {
        Object encryptionMetadata = this.cryptoHandler.loadEncryptionMetadata(this.getEncryptedHeaderContentSupplier(blobName));
        DecryptedRangedStreamProvider decryptedStreamProvider = this.cryptoHandler.createDecryptingStreamOfRange(encryptionMetadata, position, position + length - 1L);
        long adjustedPos = decryptedStreamProvider.getAdjustedRange()[0];
        long adjustedLength = decryptedStreamProvider.getAdjustedRange()[1] - adjustedPos + 1L;
        InputStream encryptedStream = this.blobContainer.readBlob(blobName, adjustedPos, adjustedLength);
        return (InputStream)decryptedStreamProvider.getDecryptedStreamProvider().apply(encryptedStream);
    }

    public long readBlobPreferredLength() {
        return this.blobContainer.readBlobPreferredLength();
    }

    private void executeWrite(InputStream inputStream, long blobSize, CheckedBiConsumer<InputStream, Long, IOException> writeConsumer) throws IOException {
        Object cryptoContext = this.cryptoHandler.initEncryptionMetadata();
        InputStreamContainer streamContainer = new InputStreamContainer(inputStream, blobSize, 0L);
        InputStreamContainer encryptedStream = this.cryptoHandler.createEncryptingStream(cryptoContext, streamContainer);
        long cryptoLength = this.cryptoHandler.estimateEncryptedLengthOfEntireContent(cryptoContext, blobSize);
        writeConsumer.accept((Object)encryptedStream.getInputStream(), (Object)cryptoLength);
    }

    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.executeWrite(inputStream, blobSize, (CheckedBiConsumer<InputStream, Long, IOException>)((CheckedBiConsumer)(encryptedStream, encryptedLength) -> this.blobContainer.writeBlob(blobName, encryptedStream, encryptedLength.longValue(), failIfAlreadyExists)));
    }

    public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.executeWrite(inputStream, blobSize, (CheckedBiConsumer<InputStream, Long, IOException>)((CheckedBiConsumer)(encryptedStream, encryptedLength) -> this.blobContainer.writeBlobAtomic(blobName, encryptedStream, encryptedLength.longValue(), failIfAlreadyExists)));
    }

    public DeleteResult delete() throws IOException {
        return this.blobContainer.delete();
    }

    public void deleteBlobsIgnoringIfNotExists(List<String> blobNames) throws IOException {
        this.blobContainer.deleteBlobsIgnoringIfNotExists(blobNames);
    }

    public Map<String, BlobMetadata> listBlobs() throws IOException {
        Map blobMetadataMap = this.blobContainer.listBlobs();
        return this.convertToEncryptedMetadataMap(blobMetadataMap);
    }

    public Map<String, BlobContainer> children() throws IOException {
        Map children = this.blobContainer.children();
        if (children != null) {
            return children.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new EncryptedBlobContainer<T, U>((BlobContainer)entry.getValue(), this.cryptoHandler)));
        }
        return null;
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(String blobNamePrefix) throws IOException {
        Map blobMetadataMap = this.blobContainer.listBlobsByPrefix(blobNamePrefix);
        return this.convertToEncryptedMetadataMap(blobMetadataMap);
    }

    private Map<String, BlobMetadata> convertToEncryptedMetadataMap(Map<String, BlobMetadata> blobMetadataMap) {
        if (blobMetadataMap == null) {
            return null;
        }
        return blobMetadataMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new EncryptedBlobMetadata<T, U>((BlobMetadata)entry.getValue(), this.cryptoHandler, this.getEncryptedHeaderContentSupplier((String)entry.getKey()))));
    }

    public void listBlobsByPrefixInSortedOrder(String blobNamePrefix, int limit, BlobContainer.BlobNameSortOrder blobNameSortOrder, ActionListener<List<BlobMetadata>> listener) {
        ActionListener<List> encryptedMetadataListener = ActionListenerHelper.delegateFailure(listener, (delegatedListener, metadataList) -> {
            if (metadataList != null) {
                List encryptedMetadata = metadataList.stream().map(blobMetadata -> new EncryptedBlobMetadata<T, U>((BlobMetadata)blobMetadata, this.cryptoHandler, this.getEncryptedHeaderContentSupplier(blobMetadata.name()))).collect(Collectors.toList());
                delegatedListener.onResponse(encryptedMetadata);
            } else {
                delegatedListener.onResponse(null);
            }
        });
        this.blobContainer.listBlobsByPrefixInSortedOrder(blobNamePrefix, limit, blobNameSortOrder, encryptedMetadataListener);
    }
}

