/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.blobstore;

import io.skylite.common.blobstore.BlobMetadata;
import io.skylite.common.crypto.CryptoHandler;
import io.skylite.common.crypto.EncryptedHeaderContentSupplier;
import java.io.IOException;

public class EncryptedBlobMetadata<T, U>
implements BlobMetadata {
    private final EncryptedHeaderContentSupplier encryptedHeaderContentSupplier;
    private final BlobMetadata delegate;
    private final CryptoHandler<T, U> cryptoHandler;

    public EncryptedBlobMetadata(BlobMetadata delegate, CryptoHandler<T, U> cryptoHandler, EncryptedHeaderContentSupplier encryptedHeaderContentSupplier) {
        this.encryptedHeaderContentSupplier = encryptedHeaderContentSupplier;
        this.delegate = delegate;
        this.cryptoHandler = cryptoHandler;
    }

    public String name() {
        return this.delegate.name();
    }

    public long length() {
        Object cryptoContext;
        try {
            cryptoContext = this.cryptoHandler.loadEncryptionMetadata(this.encryptedHeaderContentSupplier);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this.cryptoHandler.estimateDecryptedLength(cryptoContext, this.delegate.length());
    }
}

