/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.blobstore;

import io.skylite.common.blobstore.BlobContainer;
import io.skylite.common.blobstore.BlobMetadata;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.common.blobstore.DeleteResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class FilterBlobContainer
implements BlobContainer {
    private final BlobContainer delegate;

    public FilterBlobContainer(BlobContainer delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    protected abstract BlobContainer wrapChild(BlobContainer var1);

    public BlobPath path() {
        return this.delegate.path();
    }

    public boolean blobExists(String blobName) throws IOException {
        return this.delegate.blobExists(blobName);
    }

    public InputStream readBlob(String blobName) throws IOException {
        return this.delegate.readBlob(blobName);
    }

    public InputStream readBlob(String blobName, long position, long length) throws IOException {
        return this.delegate.readBlob(blobName, position, length);
    }

    public long readBlobPreferredLength() {
        return this.delegate.readBlobPreferredLength();
    }

    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.delegate.writeBlob(blobName, inputStream, blobSize, failIfAlreadyExists);
    }

    public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.delegate.writeBlobAtomic(blobName, inputStream, blobSize, failIfAlreadyExists);
    }

    public DeleteResult delete() throws IOException {
        return this.delegate.delete();
    }

    public void deleteBlobsIgnoringIfNotExists(List<String> blobNames) throws IOException {
        this.delegate.deleteBlobsIgnoringIfNotExists(blobNames);
    }

    public Map<String, BlobMetadata> listBlobs() throws IOException {
        return this.delegate.listBlobs();
    }

    public Map<String, BlobContainer> children() throws IOException {
        return this.delegate.children().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.wrapChild((BlobContainer)e.getValue())));
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(String blobNamePrefix) throws IOException {
        return this.delegate.listBlobsByPrefix(blobNamePrefix);
    }
}

