/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.blobstore.stream.read.listener;

import io.skylite.common.SuppressForbidden;
import io.skylite.common.UUIDs;
import io.skylite.common.action.ActionListener;
import io.skylite.common.annotation.InternalApi;
import io.skylite.common.io.FilePartWriter;
import io.skylite.common.io.InputStreamContainer;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.GroupedActionListener;
import io.skylite.core.blobstore.stream.read.ReadContext;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.IOUtils;

@InternalApi
public class ReadContextListener
implements ActionListener<ReadContext> {
    private static final Logger logger = LogManager.getLogger(ReadContextListener.class);
    private static final String DOWNLOAD_PREFIX = "download.";
    private final String blobName;
    private final Path fileLocation;
    private final String tmpFileName;
    private final Path tmpFileLocation;
    private final ActionListener<String> completionListener;
    private final ThreadPool threadPool;
    private final UnaryOperator<InputStream> rateLimiter;
    private final int maxConcurrentStreams;

    public ReadContextListener(String blobName, Path fileLocation, ActionListener<String> completionListener, ThreadPool threadPool, UnaryOperator<InputStream> rateLimiter, int maxConcurrentStreams) {
        this.blobName = blobName;
        this.fileLocation = fileLocation;
        this.completionListener = completionListener;
        this.threadPool = threadPool;
        this.rateLimiter = rateLimiter;
        this.maxConcurrentStreams = maxConcurrentStreams;
        this.tmpFileName = DOWNLOAD_PREFIX + UUIDs.randomBase64UUID() + "." + blobName;
        this.tmpFileLocation = fileLocation.getParent().resolve(this.tmpFileName);
    }

    public void onResponse(ReadContext readContext) {
        logger.debug("Received {} parts for blob {}", (Object)readContext.getNumberOfParts(), (Object)this.blobName);
        int numParts = readContext.getNumberOfParts();
        AtomicBoolean anyPartStreamFailed = new AtomicBoolean(false);
        GroupedActionListener<String> groupedListener = new GroupedActionListener<String>(this.getFileCompletionListener(), numParts);
        ConcurrentLinkedQueue<ReadContext.StreamPartCreator> queue = new ConcurrentLinkedQueue<ReadContext.StreamPartCreator>(readContext.getPartStreams());
        StreamPartProcessor processor = new StreamPartProcessor(queue, anyPartStreamFailed, this.tmpFileLocation, groupedListener, this.threadPool.executor("remote_recovery"), this.rateLimiter);
        for (int i = 0; i < Math.min(this.maxConcurrentStreams, queue.size()); ++i) {
            processor.process((ReadContext.StreamPartCreator)queue.poll());
        }
    }

    @SuppressForbidden(reason="need to fsync once all parts received")
    private ActionListener<Collection<String>> getFileCompletionListener() {
        return ActionListenerHelper.wrap(response -> {
            logger.trace("renaming temp file [{}] to [{}]", (Object)this.tmpFileLocation, (Object)this.fileLocation);
            try {
                IOUtils.fsync((Path)this.tmpFileLocation, (boolean)false);
                Files.move(this.tmpFileLocation, this.fileLocation, StandardCopyOption.ATOMIC_MOVE);
                IOUtils.fsync((Path)this.fileLocation.getParent(), (boolean)true);
                this.completionListener.onResponse((Object)this.blobName);
            }
            catch (IOException e) {
                logger.error("Unable to rename temp file + " + String.valueOf(this.tmpFileLocation), (Throwable)e);
                this.completionListener.onFailure((Exception)e);
            }
        }, e -> {
            try {
                Files.deleteIfExists(this.tmpFileLocation);
            }
            catch (IOException ex) {
                logger.warn("Unable to clean temp file {}", (Object)this.tmpFileLocation);
            }
            this.completionListener.onFailure(e);
        });
    }

    Path getTmpFileLocation() {
        return this.tmpFileLocation;
    }

    public void onFailure(Exception e) {
        this.completionListener.onFailure(e);
    }

    private static class StreamPartProcessor {
        private static final RuntimeException CANCELED_PART_EXCEPTION = new RuntimeException("Canceled part download due to previous failure");
        private final Queue<ReadContext.StreamPartCreator> queue;
        private final AtomicBoolean anyPartStreamFailed;
        private final Path fileLocation;
        private final GroupedActionListener<String> completionListener;
        private final Executor executor;
        private final UnaryOperator<InputStream> rateLimiter;

        private StreamPartProcessor(Queue<ReadContext.StreamPartCreator> queue, AtomicBoolean anyPartStreamFailed, Path fileLocation, GroupedActionListener<String> completionListener, Executor executor, UnaryOperator<InputStream> rateLimiter) {
            this.queue = queue;
            this.anyPartStreamFailed = anyPartStreamFailed;
            this.fileLocation = fileLocation;
            this.completionListener = completionListener;
            this.executor = executor;
            this.rateLimiter = rateLimiter;
        }

        private void process(ReadContext.StreamPartCreator supplier) {
            if (supplier == null) {
                return;
            }
            ((CompletableFuture)supplier.get()).whenCompleteAsync((blobPartStreamContainer, throwable) -> {
                if (throwable != null) {
                    this.processFailure(throwable instanceof Exception ? (Exception)throwable : new RuntimeException((Throwable)throwable));
                } else if (this.anyPartStreamFailed.get()) {
                    this.processFailure(CANCELED_PART_EXCEPTION);
                } else {
                    try {
                        FilePartWriter.write((Path)this.fileLocation, (InputStreamContainer)blobPartStreamContainer, this.rateLimiter);
                        this.completionListener.onResponse(this.fileLocation.toString());
                        this.process(this.queue.poll());
                    }
                    catch (Exception e) {
                        this.processFailure(e);
                    }
                }
            }, this.executor);
        }

        private void processFailure(Exception e) {
            if (!this.anyPartStreamFailed.getAndSet(true)) {
                this.completionListener.onFailure(e);
                ReadContext.StreamPartCreator item = this.queue.poll();
                while (item != null) {
                    this.completionListener.onFailure(CANCELED_PART_EXCEPTION);
                    item = this.queue.poll();
                }
            } else {
                this.completionListener.onFailure(e);
            }
            try {
                Files.deleteIfExists(this.fileLocation);
            }
            catch (IOException ex) {
                logger.info("Failed to delete file {} on stream failure: {}", (Object)this.fileLocation, (Object)ex);
            }
        }
    }
}

