/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.blobstore.transfer.stream;

import io.skylite.core.blobstore.transfer.stream.OffsetRangeInputStream;
import io.skylite.core.common.io.stream.StreamLimiter;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.lucene.store.RateLimiter;

public class RateLimitingOffsetRangeInputStream
extends OffsetRangeInputStream {
    private final StreamLimiter streamLimiter;
    private final OffsetRangeInputStream delegate;

    public RateLimitingOffsetRangeInputStream(OffsetRangeInputStream delegate, Supplier<RateLimiter> rateLimiterSupplier, StreamLimiter.Listener listener) {
        this.streamLimiter = new StreamLimiter(rateLimiterSupplier, listener);
        this.delegate = delegate;
    }

    @Override
    public void setReadBlock(AtomicBoolean readBlock) {
        this.delegate.setReadBlock(readBlock);
    }

    @Override
    public int read() throws IOException {
        int b = this.delegate.read();
        this.streamLimiter.maybePause(1);
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.delegate.read(b, off, len);
        if (n > 0) {
            this.streamLimiter.maybePause(n);
        }
        return n;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.delegate.getFilePointer();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

