/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.bootstrap;

import io.skylite.core.bootstrap.ConsoleCtrlHandler;
import io.skylite.core.bootstrap.JNANatives;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Natives {
    private static final Logger logger = LogManager.getLogger(Natives.class);
    static final boolean JNA_AVAILABLE;

    private Natives() {
    }

    public static void tryMlockall() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot mlockall because JNA is not available");
            return;
        }
        JNANatives.tryMlockall();
    }

    public static boolean definitelyRunningAsRoot() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot check if running as root because JNA is not available");
            return false;
        }
        return JNANatives.definitelyRunningAsRoot();
    }

    public static void tryVirtualLock() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot virtual lock because JNA is not available");
            return;
        }
        JNANatives.tryVirtualLock();
    }

    public static String getShortPathName(String path) {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot obtain short path for [{}] because JNA is not available", (Object)path);
            return path;
        }
        return JNANatives.getShortPathName(path);
    }

    public static void addConsoleCtrlHandler(ConsoleCtrlHandler handler) {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot register console handler because JNA is not available");
            return;
        }
        JNANatives.addConsoleCtrlHandler(handler);
    }

    public static boolean isMemoryLocked() {
        if (!JNA_AVAILABLE) {
            return false;
        }
        return JNANatives.LOCAL_MLOCKALL;
    }

    public static void tryInstallSystemCallFilter(Path tmpFile) {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot install system call filter because JNA is not available");
            return;
        }
        JNANatives.tryInstallSystemCallFilter(tmpFile);
    }

    public static void trySetMaxNumberOfThreads() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot getrlimit RLIMIT_NPROC because JNA is not available");
            return;
        }
        JNANatives.trySetMaxNumberOfThreads();
    }

    public static void trySetMaxSizeVirtualMemory() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot getrlimit RLIMIT_AS because JNA is not available");
            return;
        }
        JNANatives.trySetMaxSizeVirtualMemory();
    }

    public static void trySetMaxFileSize() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot getrlimit RLIMIT_FSIZE because JNA is not available");
            return;
        }
        JNANatives.trySetMaxFileSize();
    }

    static boolean isSystemCallFilterInstalled() {
        if (!JNA_AVAILABLE) {
            return false;
        }
        return JNANatives.LOCAL_SYSTEM_CALL_FILTER;
    }

    static {
        boolean v = false;
        try {
            Class.forName("com.sun.jna.Native");
            v = true;
        }
        catch (ClassNotFoundException e) {
            logger.warn("JNA not found. native methods will be disabled.", (Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn("unable to load JNA native support library, native methods will be disabled.", (Throwable)e);
        }
        JNA_AVAILABLE = v;
    }
}

