/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.client.metadata;

import io.skylite.SkyliteException;
import io.skylite.common.Nullable;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.client.metadata.DataObjectResponse;
import io.skylite.core.client.metadata.DeleteDataObjectResponse;
import io.skylite.core.client.metadata.MetadataClientUtils;
import io.skylite.core.client.metadata.PutDataObjectResponse;
import io.skylite.core.client.metadata.UpdateDataObjectResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;

public class BulkDataObjectResponse {
    private final DataObjectResponse[] responses;
    private final long tookInMillis;
    private final long ingestTookInMillis;
    private final boolean failures;
    private final XContentParser parser;
    private final NamedXContentRegistry namedXContentRegistry;
    private final BulkResponse bulkResponse;

    public BulkDataObjectResponse(BulkResponse bulkResponse, NamedXContentRegistry namedXContentRegistry) {
        this(BulkDataObjectResponse.generateDataObjectResponseArray(bulkResponse, namedXContentRegistry), bulkResponse.getTook().millis(), -1L, bulkResponse.hasFailures(), null, namedXContentRegistry, bulkResponse);
    }

    private static DataObjectResponse[] generateDataObjectResponseArray(BulkResponse bulkResponse, NamedXContentRegistry namedXContentRegistry) {
        return (DataObjectResponse[])Arrays.stream(bulkResponse.getItems()).map(itemResponse -> switch (itemResponse.getOpType()) {
            case DocWriteRequest.OpType.INDEX, DocWriteRequest.OpType.CREATE -> new PutDataObjectResponse((BulkItemResponse)itemResponse, namedXContentRegistry);
            case DocWriteRequest.OpType.UPDATE -> new UpdateDataObjectResponse((BulkItemResponse)itemResponse, namedXContentRegistry);
            case DocWriteRequest.OpType.DELETE -> new DeleteDataObjectResponse((BulkItemResponse)itemResponse, namedXContentRegistry);
            default -> throw new SkyliteException("Invalid operation type for bulk response", new Object[]{RestStatus.INTERNAL_SERVER_ERROR});
        }).toArray(DataObjectResponse[]::new);
    }

    public BulkDataObjectResponse(DataObjectResponse[] responses, long tookInMillis, boolean failures, XContentParser parser, NamedXContentRegistry namedXContentRegistry) {
        this(responses, tookInMillis, -1L, failures, parser, namedXContentRegistry, null);
    }

    public BulkDataObjectResponse(DataObjectResponse[] responses, long tookInMillis, long ingestTookInMillis, boolean failures, XContentParser parser, NamedXContentRegistry namedXContentRegistry) {
        this(responses, tookInMillis, ingestTookInMillis, failures, parser, namedXContentRegistry, null);
    }

    private BulkDataObjectResponse(DataObjectResponse[] responses, long tookInMillis, long ingestTookInMillis, boolean failures, XContentParser parser, NamedXContentRegistry namedXContentRegistry, BulkResponse bulkResponse) {
        this.responses = responses;
        this.tookInMillis = tookInMillis;
        this.ingestTookInMillis = ingestTookInMillis;
        this.failures = failures;
        this.parser = parser;
        this.namedXContentRegistry = namedXContentRegistry;
        this.bulkResponse = bulkResponse;
    }

    public DataObjectResponse[] getResponses() {
        return this.responses;
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public long getIngestTookInMillis() {
        return this.ingestTookInMillis;
    }

    public boolean hasFailures() {
        return this.failures;
    }

    @Nullable
    public BulkResponse bulkResponse() {
        if (this.bulkResponse == null) {
            try {
                return BulkResponse.fromXContent(this.parser);
            }
            catch (IOException | NullPointerException e) {
                return null;
            }
        }
        return this.bulkResponse;
    }

    public XContentParser parser() {
        if (this.parser == null) {
            try {
                return MetadataClientUtils.createParser(this.bulkResponse, this.namedXContentRegistry);
            }
            catch (IOException | NullPointerException e) {
                return null;
            }
        }
        return this.parser;
    }
}

