/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.client.metadata;

import io.skylite.common.Nullable;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.client.metadata.DataObjectResponse;
import io.skylite.core.client.metadata.MetadataClientUtils;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class GetDataObjectResponse
extends DataObjectResponse {
    private final Map<String, Object> source;
    private final GetResponse getResponse;

    public GetDataObjectResponse(GetResponse getResponse, NamedXContentRegistry namedXContentRegistry) {
        super(getResponse.getIndex(), getResponse.getId(), null, namedXContentRegistry, false, null, null);
        this.getResponse = getResponse;
        this.source = Optional.ofNullable(getResponse.getSourceAsMap()).orElse(Collections.emptyMap());
    }

    public GetDataObjectResponse(String index, String id, XContentParser parser, NamedXContentRegistry namedXContentRegistry, boolean failed, Exception cause, RestStatus status, Map<String, Object> source) {
        super(index, id, parser, namedXContentRegistry, failed, cause, status);
        this.getResponse = null;
        this.source = source;
    }

    public Map<String, Object> source() {
        return this.source;
    }

    @Nullable
    public GetResponse getResponse() {
        if (this.getResponse == null) {
            try {
                return GetResponse.fromXContent(this.parser());
            }
            catch (IOException | NullPointerException e) {
                return null;
            }
        }
        return this.getResponse;
    }

    @Override
    public XContentParser parser() {
        if (super.parser() == null) {
            try {
                return MetadataClientUtils.createParser(this.getResponse, this.namedXContentRegistry);
            }
            catch (IOException | NullPointerException e) {
                return null;
            }
        }
        return super.parser();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DataObjectResponse.Builder<Builder> {
        private Map<String, Object> source = Collections.emptyMap();

        public Builder source(Map<String, Object> source) {
            this.source = source == null ? Collections.emptyMap() : source;
            return this;
        }

        public GetDataObjectResponse build() {
            return new GetDataObjectResponse(this.index, this.id, this.parser, this.namedXContentRegistry, this.failed, this.cause, this.status, this.source);
        }
    }
}

