/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.client.metadata;

import io.skylite.SkyliteStatusException;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.client.metadata.AbstractMetadataClient;
import io.skylite.core.client.metadata.BulkDataObjectRequest;
import io.skylite.core.client.metadata.BulkDataObjectResponse;
import io.skylite.core.client.metadata.DataObjectRequest;
import io.skylite.core.client.metadata.DeleteDataObjectRequest;
import io.skylite.core.client.metadata.DeleteDataObjectResponse;
import io.skylite.core.client.metadata.GetDataObjectRequest;
import io.skylite.core.client.metadata.GetDataObjectResponse;
import io.skylite.core.client.metadata.PutDataObjectRequest;
import io.skylite.core.client.metadata.PutDataObjectResponse;
import io.skylite.core.client.metadata.SearchDataObjectRequest;
import io.skylite.core.client.metadata.SearchDataObjectResponse;
import io.skylite.core.client.metadata.UpdateDataObjectRequest;
import io.skylite.core.client.metadata.UpdateDataObjectResponse;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalClusterIndicesClient
extends AbstractMetadataClient {
    private static final Logger log = LogManager.getLogger(LocalClusterIndicesClient.class);
    private final ReleasableSkyliteClient client;
    private final NamedXContentRegistry xContentRegistry;

    @Override
    public boolean supportsMetadataType(String metadataType) {
        return Strings.isNullOrEmpty(metadataType);
    }

    public LocalClusterIndicesClient(ReleasableSkyliteClient client, NamedXContentRegistry xContentRegistry, Map<String, String> metadataSettings) {
        super.initialize(metadataSettings);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    @Override
    public CompletionStage<PutDataObjectResponse> putDataObjectAsync(PutDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        CompletableFuture future = new CompletableFuture();
        return ThreadContext.doPrivileged(() -> {
            try {
                log.info("Indexing data object in {}", (Object)request.index());
                IndexRequest indexRequest = (IndexRequest)this.createIndexRequest(request).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.index(indexRequest, ActionListenerHelper.wrap(indexResponse -> {
                    log.info("Creation status for id {}: {}", (Object)indexResponse.getId(), (Object)indexResponse.getResult());
                    future.complete(new PutDataObjectResponse((IndexResponse)indexResponse, this.xContentRegistry));
                }, e -> future.completeExceptionally(new SkyliteStatusException("Failed to put data object in index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]))));
            }
            catch (IOException e2) {
                future.completeExceptionally(new SkyliteStatusException("Failed to parse data object to put in index " + request.index(), RestStatus.BAD_REQUEST, e2, new Object[0]));
            }
            return future;
        });
    }

    private IndexRequest createIndexRequest(PutDataObjectRequest putDataObjectRequest) throws IOException {
        try (XContentBuilder sourceBuilder = MediaTypeRegistry.JSON.contentBuilder();){
            IndexRequest indexRequest = new IndexRequest(putDataObjectRequest.index()).opType(putDataObjectRequest.overwriteIfExists() ? DocWriteRequest.OpType.INDEX : DocWriteRequest.OpType.CREATE).source(putDataObjectRequest.dataObject().toXContent(sourceBuilder, ToXContent.EMPTY_PARAMS));
            if (!Strings.isNullOrEmpty(putDataObjectRequest.id())) {
                indexRequest.id(putDataObjectRequest.id());
            }
            IndexRequest indexRequest2 = indexRequest;
            return indexRequest2;
        }
    }

    @Override
    public CompletionStage<GetDataObjectResponse> getDataObjectAsync(GetDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        CompletableFuture future = new CompletableFuture();
        return ThreadContext.doPrivileged(() -> {
            GetRequest getRequest = this.createGetRequest(request);
            this.client.get(getRequest, ActionListenerHelper.wrap(getResponse -> future.complete(new GetDataObjectResponse((GetResponse)getResponse, this.xContentRegistry)), e -> future.completeExceptionally(new SkyliteStatusException("Failed to get data object from index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]))));
            return future;
        });
    }

    private GetRequest createGetRequest(GetDataObjectRequest request) {
        return new GetRequest(request.index(), request.id()).fetchSourceContext(request.fetchSourceContext());
    }

    @Override
    public CompletionStage<UpdateDataObjectResponse> updateDataObjectAsync(UpdateDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        CompletableFuture future = new CompletableFuture();
        return ThreadContext.doPrivileged(() -> {
            try {
                log.info("Updating {} from {}", (Object)request.id(), (Object)request.index());
                UpdateRequest updateRequest = this.createUpdateRequest(request);
                this.client.update(updateRequest, ActionListenerHelper.wrap(updateResponse -> {
                    if (updateResponse == null) {
                        log.info("Null UpdateResponse");
                        future.complete(((UpdateDataObjectResponse.Builder)((UpdateDataObjectResponse.Builder)UpdateDataObjectResponse.builder().id(request.id())).parser(null)).build());
                    } else {
                        log.info("Update status for id {}: {}", (Object)updateResponse.getId(), (Object)updateResponse.getResult());
                        future.complete(new UpdateDataObjectResponse((UpdateResponse)updateResponse, this.xContentRegistry));
                    }
                }, e -> {
                    if (e instanceof VersionConflictEngineException) {
                        log.error("Document version conflict updating {} in {}: {}", (Object)request.id(), (Object)request.index(), (Object)e.getMessage());
                        future.completeExceptionally(new SkyliteStatusException("Document version conflict updating " + request.id() + " in index " + request.index(), RestStatus.CONFLICT, (Throwable)e, new Object[0]));
                    } else {
                        future.completeExceptionally(new SkyliteStatusException("Failed to update data object in index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]));
                    }
                }));
            }
            catch (IOException e2) {
                future.completeExceptionally(new SkyliteStatusException("Failed to parse data object to update in index " + request.index(), RestStatus.BAD_REQUEST, e2, new Object[0]));
            }
            return future;
        });
    }

    private UpdateRequest createUpdateRequest(UpdateDataObjectRequest updateDataObjectRequest) throws IOException {
        try (XContentBuilder sourceBuilder = MediaTypeRegistry.JSON.contentBuilder();){
            UpdateRequest updateRequest = new UpdateRequest(updateDataObjectRequest.index(), updateDataObjectRequest.id()).doc(updateDataObjectRequest.dataObject().toXContent(sourceBuilder, ToXContent.EMPTY_PARAMS));
            if (updateDataObjectRequest.ifSeqNo() != null) {
                updateRequest.setIfSeqNo(updateDataObjectRequest.ifSeqNo());
            }
            if (updateDataObjectRequest.ifPrimaryTerm() != null) {
                updateRequest.setIfPrimaryTerm(updateDataObjectRequest.ifPrimaryTerm());
            }
            if (updateDataObjectRequest.retryOnConflict() > 0) {
                updateRequest.retryOnConflict(updateDataObjectRequest.retryOnConflict());
            }
            UpdateRequest updateRequest2 = updateRequest;
            return updateRequest2;
        }
    }

    @Override
    public CompletionStage<DeleteDataObjectResponse> deleteDataObjectAsync(DeleteDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        CompletableFuture future = new CompletableFuture();
        return ThreadContext.doPrivileged(() -> {
            log.info("Deleting {} from {}", (Object)request.id(), (Object)request.index());
            DeleteRequest deleteRequest = (DeleteRequest)this.createDeleteRequest(request).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.delete(deleteRequest, ActionListenerHelper.wrap(deleteResponse -> {
                log.info("Deletion status for id {}: {}", (Object)deleteResponse.getId(), (Object)deleteResponse.getResult());
                future.complete(new DeleteDataObjectResponse((DeleteResponse)deleteResponse, this.xContentRegistry));
            }, e -> future.completeExceptionally(new SkyliteStatusException("Failed to delete data object from index " + request.index(), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]))));
            return future;
        });
    }

    private DeleteRequest createDeleteRequest(DeleteDataObjectRequest deleteDataObjectRequest) {
        return new DeleteRequest(deleteDataObjectRequest.index(), deleteDataObjectRequest.id());
    }

    @Override
    public CompletionStage<BulkDataObjectResponse> bulkDataObjectAsync(BulkDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        CompletableFuture future = new CompletableFuture();
        return ThreadContext.doPrivileged(() -> {
            try {
                log.info("Performing {} bulk actions on indices {}", (Object)request.requests().size(), request.getIndices());
                BulkRequest bulkRequest = new BulkRequest();
                for (DataObjectRequest dataObjectRequest : request.requests()) {
                    if (dataObjectRequest instanceof PutDataObjectRequest) {
                        bulkRequest.add(this.createIndexRequest((PutDataObjectRequest)dataObjectRequest));
                        continue;
                    }
                    if (dataObjectRequest instanceof UpdateDataObjectRequest) {
                        bulkRequest.add(this.createUpdateRequest((UpdateDataObjectRequest)dataObjectRequest));
                        continue;
                    }
                    if (!(dataObjectRequest instanceof DeleteDataObjectRequest)) continue;
                    bulkRequest.add(this.createDeleteRequest((DeleteDataObjectRequest)dataObjectRequest));
                }
                this.client.bulk(bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE), ActionListenerHelper.wrap(bulkResponse -> future.complete(new BulkDataObjectResponse((BulkResponse)bulkResponse, this.xContentRegistry)), e -> future.completeExceptionally(new SkyliteStatusException("Failed to execute bulk request", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]))));
            }
            catch (IOException e2) {
                future.completeExceptionally(new SkyliteStatusException("Failed to create bulk request", RestStatus.BAD_REQUEST, e2, new Object[0]));
            }
            return future;
        });
    }

    @Override
    public CompletionStage<SearchDataObjectResponse> searchDataObjectAsync(SearchDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        CompletableFuture<SearchDataObjectResponse> future = new CompletableFuture<SearchDataObjectResponse>();
        SearchSourceBuilder searchSource = request.searchSourceBuilder();
        if (Boolean.TRUE.equals(isMultiTenancyEnabled)) {
            if (request.tenantId() == null) {
                future.completeExceptionally(new SkyliteStatusException("Tenant ID is required when multitenancy is enabled.", RestStatus.BAD_REQUEST, new Object[0]));
                return future;
            }
            QueryBuilder existingQuery = searchSource.query();
            TermQueryBuilder tenantIdTermQuery = new TermQueryBuilder(this.tenantIdField, request.tenantId());
            if (existingQuery == null) {
                searchSource.query(tenantIdTermQuery);
            } else {
                BoolQueryBuilder boolQuery = existingQuery instanceof BoolQueryBuilder ? (BoolQueryBuilder)existingQuery : new BoolQueryBuilder().must(existingQuery);
                boolQuery.filter(tenantIdTermQuery);
                searchSource.query(boolQuery);
            }
            log.debug("Adding tenant id to search query {}", (Object)Arrays.toString(request.indices()));
        }
        log.info("Searching {}", (Object)Arrays.toString(request.indices()));
        return ThreadContext.doPrivileged(() -> {
            SearchRequest searchRequest = new SearchRequest(request.indices(), searchSource);
            this.client.search(searchRequest, ActionListenerHelper.wrap(searchResponse -> {
                log.info("Search returned {} hits", (Object)searchResponse.getHits().getTotalHits());
                future.complete(new SearchDataObjectResponse((SearchResponse)searchResponse, this.xContentRegistry));
            }, e -> future.completeExceptionally(new SkyliteStatusException("Failed to search indices " + Arrays.toString(request.indices()), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]))));
            return future;
        });
    }

    @Override
    public void close() throws Exception {
    }
}

