/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.client.metadata;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.metadata.BulkDataObjectResponse;
import io.skylite.core.client.metadata.DeleteDataObjectResponse;
import io.skylite.core.client.metadata.GetDataObjectResponse;
import io.skylite.core.client.metadata.PutDataObjectResponse;
import io.skylite.core.client.metadata.SearchDataObjectResponse;
import io.skylite.core.client.metadata.UpdateDataObjectResponse;
import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;

public class MetadataClientUtils {
    @SafeVarargs
    public static BiConsumer<PutDataObjectResponse, Throwable> wrapPutCompletion(ActionListener<IndexResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                MetadataClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            IndexResponse indexResponse = r.indexResponse();
            if (indexResponse == null) {
                MetadataClientUtils.handleParseFailure(listener, "index");
                return;
            }
            listener.onResponse((Object)indexResponse);
        };
    }

    @SafeVarargs
    public static BiConsumer<GetDataObjectResponse, Throwable> wrapGetCompletion(ActionListener<GetResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                MetadataClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            GetResponse getResponse = r.getResponse();
            if (getResponse == null) {
                MetadataClientUtils.handleParseFailure(listener, "get");
                return;
            }
            listener.onResponse((Object)getResponse);
        };
    }

    @SafeVarargs
    public static BiConsumer<UpdateDataObjectResponse, Throwable> wrapUpdateCompletion(ActionListener<UpdateResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                MetadataClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            UpdateResponse updateResponse = r.updateResponse();
            if (updateResponse == null) {
                MetadataClientUtils.handleParseFailure(listener, "update");
                return;
            }
            listener.onResponse((Object)updateResponse);
        };
    }

    @SafeVarargs
    public static BiConsumer<DeleteDataObjectResponse, Throwable> wrapDeleteCompletion(ActionListener<DeleteResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                MetadataClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            DeleteResponse deleteResponse = r.deleteResponse();
            if (deleteResponse == null) {
                MetadataClientUtils.handleParseFailure(listener, "delete");
                return;
            }
            listener.onResponse((Object)deleteResponse);
        };
    }

    @SafeVarargs
    public static BiConsumer<BulkDataObjectResponse, Throwable> wrapBulkCompletion(ActionListener<BulkResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                MetadataClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            BulkResponse bulkResponse = r.bulkResponse();
            if (bulkResponse == null) {
                MetadataClientUtils.handleParseFailure(listener, "bulk");
                return;
            }
            listener.onResponse((Object)bulkResponse);
        };
    }

    @SafeVarargs
    public static BiConsumer<SearchDataObjectResponse, Throwable> wrapSearchCompletion(ActionListener<SearchResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                MetadataClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            SearchResponse searchResponse = r.searchResponse();
            if (searchResponse == null) {
                MetadataClientUtils.handleParseFailure(listener, "search");
                return;
            }
            listener.onResponse((Object)searchResponse);
        };
    }

    public static XContentParser createParser(ToXContent obj, NamedXContentRegistry namedXContentRegistry) throws IOException {
        return MetadataClientUtils.createParser(Strings.toString(MediaTypeRegistry.JSON, obj), namedXContentRegistry);
    }

    public static XContentParser createParser(String json, NamedXContentRegistry namedXContentRegistry) throws IOException {
        return MediaTypeRegistry.JSON.xContent().createParser(namedXContentRegistry, DeprecationHandler.IGNORE_DEPRECATIONS, json);
    }

    private static void handleParseFailure(ActionListener<?> listener, String operation) {
        listener.onFailure((Exception)new SkyliteStatusException("Failed to parse " + operation + " response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
    }

    @SafeVarargs
    private static void handleThrowable(ActionListener<?> listener, Throwable throwable, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        Exception exception = exceptionTypesToUnwrap.length > 0 ? SkyliteExceptionsHelper.unwrapAndConvertToException(throwable, exceptionTypesToUnwrap) : SkyliteExceptionsHelper.unwrapAndConvertToException(throwable, SkyliteStatusException.class, CompletionException.class);
        listener.onFailure(exception);
    }
}

