/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.client.metadata;

import io.skylite.common.Nullable;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.client.metadata.MetadataClientUtils;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;

public class SearchDataObjectResponse {
    private final XContentParser parser;
    private final NamedXContentRegistry namedXContentRegistry;
    private final SearchResponse searchResponse;

    public SearchDataObjectResponse(SearchResponse searchResponse, NamedXContentRegistry namedXContentRegistry) {
        this.searchResponse = searchResponse;
        this.parser = null;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    public SearchDataObjectResponse(XContentParser parser, NamedXContentRegistry namedXContentRegistry) {
        this.parser = parser;
        this.namedXContentRegistry = namedXContentRegistry;
        this.searchResponse = null;
    }

    @Nullable
    public SearchResponse searchResponse() {
        if (this.searchResponse == null) {
            try {
                return SearchResponse.fromXContent(this.parser);
            }
            catch (IOException | NullPointerException e) {
                return null;
            }
        }
        return this.searchResponse;
    }

    public XContentParser parser() {
        if (this.parser == null) {
            try {
                return MetadataClientUtils.createParser(this.searchResponse, this.namedXContentRegistry);
            }
            catch (IOException | NullPointerException e) {
                return null;
            }
        }
        return this.parser;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private XContentParser parser = null;
        private NamedXContentRegistry namedXContentRegistry = null;

        private Builder() {
        }

        public Builder parser(XContentParser parser) {
            this.parser = parser;
            return this;
        }

        public Builder namedXContentRegistry(NamedXContentRegistry namedXContentRegistry) {
            this.namedXContentRegistry = namedXContentRegistry;
            return this;
        }

        public SearchDataObjectResponse build() {
            return new SearchDataObjectResponse(this.parser, this.namedXContentRegistry);
        }
    }
}

