/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.action.index;

import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.RunOnce;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.admin.indices.mapping.put.AutoPutMappingAction;
import io.skylite.core.action.admin.indices.mapping.put.PutMappingRequest;
import io.skylite.core.client.Client;
import io.skylite.core.client.IndicesAdminClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.UncategorizedExecutionException;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.Index;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.xcontent.MediaTypeRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;

public class MappingUpdatedAction {
    public static final Setting<TimeValue> INDICES_MAPPING_DYNAMIC_TIMEOUT_SETTING = Setting.positiveTimeSetting("indices.mapping.dynamic_timeout", TimeValue.timeValueSeconds((long)30L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> INDICES_MAX_IN_FLIGHT_UPDATES_SETTING = Setting.intSetting("indices.mapping.max_in_flight_updates", 10, 1, 1000, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private IndicesAdminClient client;
    private volatile TimeValue dynamicMappingUpdateTimeout;
    private final AdjustableSemaphore semaphore;
    private final ClusterService clusterService;

    @Inject
    public MappingUpdatedAction(Settings settings, ClusterSettings clusterSettings, ClusterService clusterService) {
        this.dynamicMappingUpdateTimeout = INDICES_MAPPING_DYNAMIC_TIMEOUT_SETTING.get(settings);
        this.semaphore = new AdjustableSemaphore(INDICES_MAX_IN_FLIGHT_UPDATES_SETTING.get(settings), true);
        this.clusterService = clusterService;
        clusterSettings.addSettingsUpdateConsumer(INDICES_MAPPING_DYNAMIC_TIMEOUT_SETTING, this::setDynamicMappingUpdateTimeout);
        clusterSettings.addSettingsUpdateConsumer(INDICES_MAX_IN_FLIGHT_UPDATES_SETTING, this::setMaxInFlightUpdates);
    }

    private void setDynamicMappingUpdateTimeout(TimeValue dynamicMappingUpdateTimeout) {
        this.dynamicMappingUpdateTimeout = dynamicMappingUpdateTimeout;
    }

    private void setMaxInFlightUpdates(int maxInFlightUpdates) {
        this.semaphore.setMaxPermits(maxInFlightUpdates);
    }

    public void setClient(Client client) {
        this.client = client.admin().indices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMappingOnClusterManager(Index index, String mappingUpdate, ActionListener<Void> listener) {
        RunOnce release = new RunOnce(() -> this.semaphore.release());
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            listener.onFailure((Exception)e);
            return;
        }
        boolean successFullySent = false;
        try {
            this.sendUpdateMapping(index, mappingUpdate, ActionListenerHelper.runBefore(listener, () -> ((RunOnce)release).run()));
            successFullySent = true;
        }
        finally {
            if (!successFullySent) {
                release.run();
            }
        }
    }

    @Deprecated
    public void updateMappingOnMaster(Index index, String mappingUpdate, ActionListener<Void> listener) {
        this.updateMappingOnClusterManager(index, mappingUpdate, listener);
    }

    int blockedThreads() {
        return this.semaphore.getQueueLength();
    }

    protected void sendUpdateMapping(Index index, String mappingUpdate, ActionListener<Void> listener) {
        PutMappingRequest putMappingRequest = new PutMappingRequest();
        putMappingRequest.setConcreteIndex(index);
        putMappingRequest.source(mappingUpdate, MediaTypeRegistry.JSON);
        putMappingRequest.clusterManagerNodeTimeout(this.dynamicMappingUpdateTimeout);
        putMappingRequest.timeout(TimeValue.ZERO);
        this.client.execute(AutoPutMappingAction.INSTANCE, putMappingRequest, ActionListenerHelper.wrap(r -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0)));
    }

    private static Exception unwrapException(Exception cause) {
        return cause instanceof SkyliteException ? MappingUpdatedAction.unwrapEsException((SkyliteException)cause) : cause;
    }

    private static RuntimeException unwrapEsException(SkyliteException esEx) {
        Throwable root = esEx.unwrapCause();
        if (root instanceof RuntimeException) {
            return (RuntimeException)root;
        }
        return new UncategorizedExecutionException("Failed execution", root);
    }

    static class AdjustableSemaphore
    extends Semaphore {
        private final Object maxPermitsMutex = new Object();
        private int maxPermits;

        AdjustableSemaphore(int maxPermits, boolean fair) {
            super(maxPermits, fair);
            this.maxPermits = maxPermits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setMaxPermits(int permits) {
            Object object = this.maxPermitsMutex;
            synchronized (object) {
                int diff = Math.subtractExact(permits, this.maxPermits);
                if (diff > 0) {
                    this.release(diff);
                } else if (diff < 0) {
                    this.reducePermits(Math.negateExact(diff));
                }
                this.maxPermits = permits;
            }
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(INDICES_MAPPING_DYNAMIC_TIMEOUT_SETTING, INDICES_MAX_IN_FLIGHT_UPDATES_SETTING);
        }
    }
}

