/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.awarenesshealth;

import io.skylite.core.cluster.awarenesshealth.ClusterAwarenessAttributesHealth;
import io.skylite.core.cluster.routing.allocation.RoutingAllocationSettings;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDeciderSettings;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClusterAwarenessHealth
implements Writeable,
ToXContentFragment,
Iterable<ClusterAwarenessAttributesHealth> {
    private static final String AWARENESS_ATTRIBUTE = "awareness_attributes";
    private final Map<String, ClusterAwarenessAttributesHealth> clusterAwarenessAttributesHealthMap;

    public ClusterAwarenessHealth(ClusterState clusterState, ClusterSettings clusterSettings, String awarenessAttributeName) {
        this.clusterAwarenessAttributesHealthMap = new HashMap<String, ClusterAwarenessAttributesHealth>();
        List<String> awarenessAttributeList = this.getAwarenessAttributeList(awarenessAttributeName, clusterSettings);
        for (String awarenessAttribute : awarenessAttributeList) {
            boolean displayUnassignedShardLevelInfo = this.canCalcUnassignedShards(clusterSettings, awarenessAttribute);
            ClusterAwarenessAttributesHealth clusterAwarenessAttributesHealth = new ClusterAwarenessAttributesHealth(awarenessAttribute, displayUnassignedShardLevelInfo, clusterState);
            this.clusterAwarenessAttributesHealthMap.put(awarenessAttribute, clusterAwarenessAttributesHealth);
        }
    }

    public ClusterAwarenessHealth(StreamInput in) throws IOException {
        int size = in.readVInt();
        if (size > 0) {
            this.clusterAwarenessAttributesHealthMap = new HashMap<String, ClusterAwarenessAttributesHealth>(size);
            for (int i = 0; i < size; ++i) {
                ClusterAwarenessAttributesHealth clusterAwarenessAttributesHealth = new ClusterAwarenessAttributesHealth(in);
                this.clusterAwarenessAttributesHealthMap.put(clusterAwarenessAttributesHealth.getAwarenessAttributeName(), clusterAwarenessAttributesHealth);
            }
        } else {
            this.clusterAwarenessAttributesHealthMap = Collections.emptyMap();
        }
    }

    private List<String> getAwarenessAttributeList(String awarenessAttributeName, ClusterSettings clusterSettings) {
        boolean displayAllAwarenessAttribute = awarenessAttributeName == null || awarenessAttributeName.isBlank();
        ArrayList<String> awarenessAttributeList = new ArrayList<String>();
        if (!displayAllAwarenessAttribute) {
            awarenessAttributeList.add(awarenessAttributeName);
        } else {
            awarenessAttributeList = clusterSettings.get(AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING);
        }
        return awarenessAttributeList;
    }

    private boolean canCalcUnassignedShards(ClusterSettings clusterSettings, String awarenessAttributeName) {
        boolean allocationAwarenessBalance = clusterSettings.get(RoutingAllocationSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_BALANCE_SETTING);
        Settings forcedAwarenessSettings = clusterSettings.get(AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING);
        boolean forcedZoneSettingsExists = false;
        if (!forcedAwarenessSettings.isEmpty() && forcedAwarenessSettings.hasValue(awarenessAttributeName + ".values")) {
            forcedZoneSettingsExists = true;
        }
        return allocationAwarenessBalance && forcedZoneSettingsExists;
    }

    public Map<String, ClusterAwarenessAttributesHealth> getClusterAwarenessAttributesHealthMap() {
        return this.clusterAwarenessAttributesHealthMap;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        int size = this.clusterAwarenessAttributesHealthMap.size();
        out.writeVInt(size);
        if (size > 0) {
            for (ClusterAwarenessAttributesHealth awarenessAttributeValueHealth : this) {
                awarenessAttributeValueHealth.writeTo(out);
            }
        }
    }

    public String toString() {
        return "ClusterAwarenessHealth{clusterAwarenessHealth.clusterAwarenessAttributesHealthMap.size=" + String.valueOf(this.clusterAwarenessAttributesHealthMap == null ? "null" : Integer.valueOf(this.clusterAwarenessAttributesHealthMap.size())) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterAwarenessHealth that = (ClusterAwarenessHealth)o;
        return this.clusterAwarenessAttributesHealthMap.size() == that.clusterAwarenessAttributesHealthMap.size();
    }

    public int hashCode() {
        return Objects.hash(this.clusterAwarenessAttributesHealthMap);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(AWARENESS_ATTRIBUTE);
        for (ClusterAwarenessAttributesHealth awarenessAttributeValueHealth : this) {
            awarenessAttributeValueHealth.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public Iterator<ClusterAwarenessAttributesHealth> iterator() {
        return this.clusterAwarenessAttributesHealthMap.values().iterator();
    }
}

