/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.decommission;

import io.skylite.OpenSearchVersion;
import io.skylite.SkyliteParseException;
import io.skylite.Version;
import io.skylite.core.cluster.decommission.DecommissionAttribute;
import io.skylite.core.cluster.decommission.DecommissionStatus;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.common.AbstractNamedDiffable;
import io.skylite.core.common.NamedDiff;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class DecommissionAttributeMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "decommissionedAttribute";
    private final DecommissionAttribute decommissionAttribute;
    private DecommissionStatus status;
    private String requestID;
    public static final String attributeType = "awareness";

    public DecommissionAttributeMetadata(DecommissionAttribute decommissionAttribute, DecommissionStatus status, String requestId) {
        this.decommissionAttribute = decommissionAttribute;
        this.status = status;
        this.requestID = requestId;
    }

    public DecommissionAttributeMetadata(DecommissionAttribute decommissionAttribute, String requestID) {
        this(decommissionAttribute, DecommissionStatus.INIT, requestID);
    }

    public DecommissionAttribute decommissionAttribute() {
        return this.decommissionAttribute;
    }

    public DecommissionStatus status() {
        return this.status;
    }

    public String requestID() {
        return this.requestID;
    }

    public synchronized void validateNewStatus(DecommissionStatus newStatus) {
        if (newStatus.equals((Object)this.status) || newStatus.equals((Object)DecommissionStatus.FAILED)) {
            return;
        }
        switch (newStatus) {
            case DRAINING: {
                this.validateStatus(Set.of(DecommissionStatus.INIT), newStatus);
                break;
            }
            case IN_PROGRESS: {
                this.validateStatus(Set.of(DecommissionStatus.DRAINING, DecommissionStatus.INIT), newStatus);
                break;
            }
            case SUCCESSFUL: {
                this.validateStatus(Set.of(DecommissionStatus.IN_PROGRESS), newStatus);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal decommission status [" + newStatus.status() + "] requested for updating metadata");
            }
        }
    }

    private void validateStatus(Set<DecommissionStatus> expectedStatuses, DecommissionStatus next) {
        if (!expectedStatuses.contains((Object)this.status)) {
            assert (false) : "can't move decommission status to [" + String.valueOf((Object)next) + "]. current status: [" + String.valueOf((Object)this.status) + "] (allowed statuses [" + String.valueOf(expectedStatuses) + "])";
            throw new IllegalStateException("can't move decommission status to [" + String.valueOf((Object)next) + "]. current status: [" + String.valueOf((Object)this.status) + "] (expected [" + String.valueOf(expectedStatuses) + "])");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecommissionAttributeMetadata that = (DecommissionAttributeMetadata)o;
        if (!this.status.equals((Object)that.status)) {
            return false;
        }
        if (!this.requestID.equals(that.requestID)) {
            return false;
        }
        return this.decommissionAttribute.equals(that.decommissionAttribute);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{attributeType, this.decommissionAttribute, this.status, this.requestID});
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return OpenSearchVersion.V_2_4_0;
    }

    public DecommissionAttributeMetadata(StreamInput in) throws IOException {
        this.decommissionAttribute = new DecommissionAttribute(in);
        this.status = DecommissionStatus.fromString(in.readString());
        this.requestID = in.readString();
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return DecommissionAttributeMetadata.readDiffFrom(Metadata.Custom.class, TYPE, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.decommissionAttribute.writeTo(out);
        out.writeString(this.status.status());
        out.writeString(this.requestID);
    }

    public static DecommissionAttributeMetadata fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        DecommissionAttribute decommissionAttribute = null;
        DecommissionStatus status = null;
        String requestID = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String currentFieldName = parser.currentName();
            if (attributeType.equals(currentFieldName)) {
                if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                    throw new SkyliteParseException("failed to parse decommission attribute type [{}], expected object", attributeType);
                }
                token = parser.nextToken();
                if (token != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        String fieldName = parser.currentName();
                        token = parser.nextToken();
                        if (token != XContentParser.Token.VALUE_STRING) {
                            throw new SkyliteParseException("failed to parse attribute [{}], expected string for attribute value", fieldName);
                        }
                        String value = parser.text();
                        decommissionAttribute = new DecommissionAttribute(fieldName, value);
                        parser.nextToken();
                        continue;
                    }
                    throw new SkyliteParseException("failed to parse attribute type [{}], unexpected type", attributeType);
                }
                throw new SkyliteParseException("failed to parse attribute type [{}]", attributeType);
            }
            if ("status".equals(currentFieldName)) {
                if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                    throw new SkyliteParseException("failed to parse status of decommissioning, expected string but found unknown type", new Object[0]);
                }
                status = DecommissionStatus.fromString(parser.text());
                continue;
            }
            if ("requestID".equals(currentFieldName)) {
                if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                    throw new SkyliteParseException("failed to parse status of decommissioning, expected string but found unknown type", new Object[0]);
                }
                requestID = parser.text();
                continue;
            }
            throw new SkyliteParseException("unknown field found [{}], failed to parse the decommission attribute", currentFieldName);
        }
        return new DecommissionAttributeMetadata(decommissionAttribute, status, requestID);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        DecommissionAttributeMetadata.toXContent(this.decommissionAttribute, this.status, this.requestID, attributeType, builder, params);
        return builder;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.API_AND_GATEWAY;
    }

    public static void toXContent(DecommissionAttribute decommissionAttribute, DecommissionStatus status, String requestID, String attributeType, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(attributeType);
        builder.field(decommissionAttribute.attributeName(), decommissionAttribute.attributeValue());
        builder.endObject();
        builder.field("status", status.status());
        builder.field("requestID", requestID);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }
}

