/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.metadata;

import io.skylite.Version;
import io.skylite.core.ParseField;
import io.skylite.core.cluster.metadata.ComponentTemplate;
import io.skylite.core.cluster.metadata.ComposableIndexTemplateMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.common.Diff;
import io.skylite.core.common.DiffableUtils;
import io.skylite.core.common.NamedDiff;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ComponentTemplateMetadata
implements Metadata.Custom {
    public static final String TYPE = "component_template";
    private static final ParseField COMPONENT_TEMPLATE = new ParseField("component_template", new String[0]);
    private static final ConstructingObjectParser<ComponentTemplateMetadata, Void> PARSER = new ConstructingObjectParser("component_template", false, a -> new ComponentTemplateMetadata((Map)a[0]));
    private final Map<String, ComponentTemplate> componentTemplates;

    public ComponentTemplateMetadata(Map<String, ComponentTemplate> componentTemplates) {
        this.componentTemplates = componentTemplates;
    }

    public ComponentTemplateMetadata(StreamInput in) throws IOException {
        this.componentTemplates = in.readMap(StreamInput::readString, ComponentTemplate::new);
    }

    public Map<String, ComponentTemplate> componentTemplates() {
        return this.componentTemplates;
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom before) {
        return new ComponentTemplateMetadataDiff((ComponentTemplateMetadata)before, this);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new ComponentTemplateMetadataDiff(in);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return ComposableIndexTemplateMetadata.MINIMMAL_SUPPORTED_VERSION;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.componentTemplates, StreamOutput::writeString, (stream, val) -> val.writeTo(stream));
    }

    public static ComponentTemplateMetadata fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(COMPONENT_TEMPLATE.getPreferredName());
        for (Map.Entry<String, ComponentTemplate> template : this.componentTemplates.entrySet()) {
            builder.field(template.getKey(), template.getValue());
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.componentTemplates);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ComponentTemplateMetadata other = (ComponentTemplateMetadata)obj;
        return Objects.equals(this.componentTemplates, other.componentTemplates);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            HashMap<String, ComponentTemplate> templates = new HashMap<String, ComponentTemplate>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                String name = p.currentName();
                templates.put(name, ComponentTemplate.parse(p));
            }
            return templates;
        }, COMPONENT_TEMPLATE);
    }

    static class ComponentTemplateMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, ComponentTemplate>> componentTemplateDiff;

        ComponentTemplateMetadataDiff(ComponentTemplateMetadata before, ComponentTemplateMetadata after) {
            this.componentTemplateDiff = DiffableUtils.diff(before.componentTemplates, after.componentTemplates, DiffableUtils.getStringKeySerializer());
        }

        ComponentTemplateMetadataDiff(StreamInput in) throws IOException {
            this.componentTemplateDiff = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), ComponentTemplate::new, ComponentTemplate::readComponentTemplateDiffFrom);
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            return new ComponentTemplateMetadata(this.componentTemplateDiff.apply(((ComponentTemplateMetadata)part).componentTemplates));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.componentTemplateDiff.writeTo(out);
        }

        @Override
        public String getWriteableName() {
            return ComponentTemplateMetadata.TYPE;
        }
    }
}

