/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.metadata;

import io.skylite.LuceniaVersion;
import io.skylite.Version;
import io.skylite.common.Nullable;
import io.skylite.core.ParseField;
import io.skylite.core.cluster.metadata.DataStream;
import io.skylite.core.cluster.metadata.Template;
import io.skylite.core.common.AbstractDiffable;
import io.skylite.core.common.Diff;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ComposableIndexTemplate
extends AbstractDiffable<ComposableIndexTemplate>
implements ToXContentObject {
    private static final ParseField INDEX_PATTERNS = new ParseField("index_patterns", new String[0]);
    private static final ParseField TEMPLATE = new ParseField("template", new String[0]);
    private static final ParseField PRIORITY = new ParseField("priority", new String[0]);
    private static final ParseField COMPOSED_OF = new ParseField("composed_of", new String[0]);
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static final ParseField METADATA = new ParseField("_meta", new String[0]);
    private static final ParseField DATA_STREAM = new ParseField("data_stream", new String[0]);
    private static final ParseField ALLOW_AUTO_CREATE = new ParseField("allow_auto_create", new String[0]);
    private static final Version<?> ALLOW_AUTO_CREATE_VERSION = LuceniaVersion.V_0_1_0;
    public static final ConstructingObjectParser<ComposableIndexTemplate, Void> PARSER = new ConstructingObjectParser("index_template", false, a -> new ComposableIndexTemplate((List)a[0], (Template)a[1], (List)a[2], (Long)a[3], (Long)a[4], (Map)a[5], (DataStreamTemplate)a[6], (Boolean)a[7]));
    private final List<String> indexPatterns;
    @Nullable
    private final Template template;
    @Nullable
    private final List<String> componentTemplates;
    @Nullable
    private final Long priority;
    @Nullable
    private final Long version;
    @Nullable
    private final Map<String, Object> metadata;
    @Nullable
    private final DataStreamTemplate dataStreamTemplate;
    @Nullable
    private final Boolean allowAutoCreate;

    static Diff<ComposableIndexTemplate> readITV2DiffFrom(StreamInput in) throws IOException {
        return AbstractDiffable.readDiffFrom(ComposableIndexTemplate::new, in);
    }

    public static ComposableIndexTemplate parse(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public ComposableIndexTemplate(List<String> indexPatterns, @Nullable Template template, @Nullable List<String> componentTemplates, @Nullable Long priority, @Nullable Long version, @Nullable Map<String, Object> metadata) {
        this(indexPatterns, template, componentTemplates, priority, version, metadata, null, null);
    }

    public ComposableIndexTemplate(List<String> indexPatterns, @Nullable Template template, @Nullable List<String> componentTemplates, @Nullable Long priority, @Nullable Long version, @Nullable Map<String, Object> metadata, @Nullable DataStreamTemplate dataStreamTemplate, @Nullable Boolean allowAutoCreate) {
        this.indexPatterns = indexPatterns;
        this.template = template;
        this.componentTemplates = componentTemplates;
        this.priority = priority;
        this.version = version;
        this.metadata = metadata;
        this.dataStreamTemplate = dataStreamTemplate;
        this.allowAutoCreate = allowAutoCreate;
    }

    public ComposableIndexTemplate(StreamInput in) throws IOException {
        this.indexPatterns = in.readStringList();
        this.template = in.readBoolean() ? new Template(in) : null;
        this.componentTemplates = in.readOptionalStringList();
        this.priority = in.readOptionalVLong();
        this.version = in.readOptionalVLong();
        this.metadata = in.readMap();
        this.dataStreamTemplate = in.readOptionalWriteable(DataStreamTemplate::new);
        this.allowAutoCreate = in.getVersion().onOrAfter(ALLOW_AUTO_CREATE_VERSION) ? in.readOptionalBoolean() : null;
    }

    public List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Nullable
    public Template template() {
        return this.template;
    }

    public List<String> composedOf() {
        if (this.componentTemplates == null) {
            return Collections.emptyList();
        }
        return this.componentTemplates;
    }

    public Long priority() {
        return this.priority;
    }

    public long priorityOrZero() {
        if (this.priority == null) {
            return 0L;
        }
        return this.priority;
    }

    public Long version() {
        return this.version;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public DataStreamTemplate getDataStreamTemplate() {
        return this.dataStreamTemplate;
    }

    @Nullable
    public Boolean getAllowAutoCreate() {
        return this.allowAutoCreate;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.indexPatterns);
        if (this.template == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.template.writeTo(out);
        }
        out.writeOptionalStringCollection(this.componentTemplates);
        out.writeOptionalVLong(this.priority);
        out.writeOptionalVLong(this.version);
        out.writeMap(this.metadata);
        out.writeOptionalWriteable(this.dataStreamTemplate);
        if (out.getVersion().onOrAfter(ALLOW_AUTO_CREATE_VERSION)) {
            out.writeOptionalBoolean(this.allowAutoCreate);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX_PATTERNS.getPreferredName(), this.indexPatterns);
        if (this.template != null) {
            builder.field(TEMPLATE.getPreferredName(), this.template);
        }
        if (this.componentTemplates != null) {
            builder.field(COMPOSED_OF.getPreferredName(), this.componentTemplates);
        }
        if (this.priority != null) {
            builder.field(PRIORITY.getPreferredName(), this.priority);
        }
        if (this.version != null) {
            builder.field(VERSION.getPreferredName(), this.version);
        }
        if (this.metadata != null) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        if (this.dataStreamTemplate != null) {
            builder.field(DATA_STREAM.getPreferredName(), this.dataStreamTemplate);
        }
        if (this.allowAutoCreate != null) {
            builder.field(ALLOW_AUTO_CREATE.getPreferredName(), this.allowAutoCreate);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.indexPatterns, this.template, this.componentTemplates, this.priority, this.version, this.metadata, this.dataStreamTemplate, this.allowAutoCreate);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComposableIndexTemplate other = (ComposableIndexTemplate)obj;
        return Objects.equals(this.indexPatterns, other.indexPatterns) && Objects.equals(this.template, other.template) && Objects.equals(this.componentTemplates, other.componentTemplates) && Objects.equals(this.priority, other.priority) && Objects.equals(this.version, other.version) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.dataStreamTemplate, other.dataStreamTemplate) && Objects.equals(this.allowAutoCreate, other.allowAutoCreate);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), INDEX_PATTERNS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), Template.PARSER, TEMPLATE);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), COMPOSED_OF);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), PRIORITY);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), VERSION);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), METADATA);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DataStreamTemplate.PARSER, DATA_STREAM);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ALLOW_AUTO_CREATE);
    }

    public static class DataStreamTemplate
    implements Writeable,
    ToXContentObject {
        private static final ParseField TIMESTAMP_FIELD_FIELD = new ParseField("timestamp_field", new String[0]);
        private static final ConstructingObjectParser<DataStreamTemplate, Void> PARSER = new ConstructingObjectParser("data_stream_template", true, args -> new DataStreamTemplate((DataStream.TimestampField)args[0]));
        private final DataStream.TimestampField timestampField;

        public DataStreamTemplate() {
            this(DataStream.DEFAULT_TIMESTAMP_FIELD);
        }

        public DataStreamTemplate(DataStream.TimestampField timestampField) {
            this.timestampField = timestampField;
        }

        public DataStreamTemplate(StreamInput in) throws IOException {
            this.timestampField = in.readOptionalWriteable(DataStream.TimestampField::new);
        }

        public DataStream.TimestampField getTimestampField() {
            return this.timestampField == null ? DataStream.DEFAULT_TIMESTAMP_FIELD : this.timestampField;
        }

        public Map<String, Object> getDataStreamMappingSnippet() {
            return Collections.singletonMap("_doc", Collections.singletonMap("_data_stream_timestamp", Collections.unmodifiableMap(Map.of("enabled", true, "timestamp_field", this.getTimestampField().toMap()))));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable(this.timestampField);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(TIMESTAMP_FIELD_FIELD.getPreferredName(), this.getTimestampField()).endObject();
        }

        public static DataStreamTemplate fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataStreamTemplate that = (DataStreamTemplate)o;
            return Objects.equals(this.timestampField, that.timestampField);
        }

        public int hashCode() {
            return Objects.hash(this.timestampField);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DataStream.TimestampField.PARSER, TIMESTAMP_FIELD_FIELD);
        }
    }
}

