/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.node;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.common.UUIDs;
import io.skylite.common.annotation.PublicApi;
import io.skylite.core.cluster.node.NodeInfo;
import io.skylite.core.cluster.node.NodeRole;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.node.NodeRoleSettings;
import io.skylite.core.node.NodeSettings;
import io.skylite.core.settings.CommonSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@PublicApi(since="1.0.0")
public class DiscoveryNode
implements Writeable,
ToXContentFragment {
    private final NodeInfo nodeInfo;
    private final SortedSet<NodeRole> roles;
    private static Map<String, NodeRole> roleMap = DiscoveryNode.rolesToMap(NodeRole.BUILT_IN_ROLES.stream());

    public static boolean nodeRequiresLocalStorage(Settings settings) {
        boolean localStorageEnable = NodeSettings.NODE_LOCAL_STORAGE_SETTING.get(settings);
        if (!localStorageEnable && (DiscoveryNode.isDataNode(settings) || DiscoveryNode.isClusterManagerNode(settings))) {
            throw new IllegalArgumentException("storage can not be disabled for cluster-manager and data nodes");
        }
        return localStorageEnable;
    }

    public static boolean hasRole(Settings settings, NodeRole role) {
        if (settings.hasValue("node.roles")) {
            return settings.getAsList("node.roles").contains(role.roleName());
        }
        if (role.legacySetting() != null && settings.hasValue(role.legacySetting().getKey())) {
            return role.legacySetting().get(settings);
        }
        return role.isEnabledByDefault(settings);
    }

    public static boolean isClusterManagerNode(Settings settings) {
        return DiscoveryNode.hasRole(settings, NodeRole.MASTER_ROLE) || DiscoveryNode.hasRole(settings, NodeRole.CLUSTER_MANAGER_ROLE);
    }

    @Deprecated
    public static boolean isMasterNode(Settings settings) {
        return DiscoveryNode.isClusterManagerNode(settings);
    }

    public static boolean isDataNode(Settings settings) {
        return DiscoveryNode.getRolesFromSettings(settings).stream().anyMatch(NodeRole::canContainData);
    }

    public static boolean isIngestNode(Settings settings) {
        return DiscoveryNode.hasRole(settings, NodeRole.INGEST_ROLE);
    }

    public static boolean isRemoteClusterClient(Settings settings) {
        return DiscoveryNode.hasRole(settings, NodeRole.REMOTE_CLUSTER_CLIENT_ROLE);
    }

    public static boolean isSearchNode(Settings settings) {
        return DiscoveryNode.hasRole(settings, NodeRole.SEARCH_ROLE);
    }

    public DiscoveryNode(String id, TransportAddress address, Version version) {
        this(id, address, Collections.emptyMap(), NodeRole.BUILT_IN_ROLES, version);
    }

    public DiscoveryNode(String id, TransportAddress address, Map<String, String> attributes, Set<NodeRole> roles, Version version) {
        this("", id, address, attributes, roles, version);
    }

    public DiscoveryNode(String nodeName, String nodeId, TransportAddress address, Map<String, String> attributes, Set<NodeRole> roles, Version version) {
        this(nodeName, nodeId, UUIDs.randomBase64UUID(), address.address().getHostString(), address.getAddress(), address, attributes, roles, version);
    }

    public DiscoveryNode(String nodeName, String nodeId, String ephemeralId, String hostName, String hostAddress, TransportAddress address, Map<String, String> attributes, Set<NodeRole> roles, Version version) {
        this.nodeInfo = new NodeInfo(nodeName, nodeId, ephemeralId, hostName, hostAddress, address, attributes, version);
        Predicate<Map> predicate = attrs -> {
            boolean success = true;
            for (NodeRole role : roleMap.values()) {
                assert (success &= !attrs.containsKey(role.roleName())) : role.roleName();
            }
            return success;
        };
        assert (predicate.test(attributes)) : attributes;
        this.roles = Collections.unmodifiableSortedSet(new TreeSet<NodeRole>(roles));
    }

    public static DiscoveryNode createLocal(Settings settings, TransportAddress publishAddress, String nodeId) {
        Map<String, String> attributes = NodeSettings.NODE_ATTRIBUTES.getAsMap(settings);
        Set<NodeRole> roles = DiscoveryNode.getRolesFromSettings(settings);
        return new DiscoveryNode(CommonSettings.NODE_NAME_SETTING.get(settings), nodeId, publishAddress, attributes, roles, Version.CURRENT);
    }

    public static Set<NodeRole> getRolesFromSettings(Settings settings) {
        if (NodeRoleSettings.NODE_ROLES_SETTING.exists(settings)) {
            DiscoveryNode.validateLegacySettings(settings, roleMap);
            return Collections.unmodifiableSet(new HashSet(NodeRoleSettings.NODE_ROLES_SETTING.get(settings)));
        }
        return roleMap.values().stream().filter(s -> s.isEnabledByDefault(settings)).collect(Collectors.toSet());
    }

    private static void validateLegacySettings(Settings settings, Map<String, NodeRole> roleMap) {
        for (NodeRole role : roleMap.values()) {
            if (role.legacySetting() == null || !role.legacySetting().exists(settings)) continue;
            String message = String.format(Locale.ROOT, "can not explicitly configure node roles and use legacy role setting [%s]=[%s]", role.legacySetting().getKey(), role.legacySetting().get(settings));
            throw new IllegalArgumentException(message);
        }
    }

    public DiscoveryNode(StreamInput in) throws IOException {
        String nodeName = in.readString().intern();
        String nodeId = in.readString().intern();
        String ephemeralId = in.readString().intern();
        String hostName = in.readString().intern();
        String hostAddress = in.readString().intern();
        TransportAddress address = new TransportAddress(in);
        int size = in.readVInt();
        HashMap<String, String> attributes = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            attributes.put(in.readString(), in.readString());
        }
        int rolesSize = in.readVInt();
        HashSet<NodeRole> roles = new HashSet<NodeRole>(rolesSize);
        for (int i = 0; i < rolesSize; ++i) {
            String roleName = in.readString();
            String roleNameAbbreviation = in.readString();
            boolean canContainData = in.readBoolean();
            NodeRole role = roleMap.get(roleName);
            if (role == null) {
                if (in.getVersion().onOrAfter(OpenSearchVersion.V_2_1_0)) {
                    roles.add(new NodeRole.DynamicRole(roleName, roleNameAbbreviation, canContainData));
                    continue;
                }
                roles.add(new NodeRole.UnknownRole(roleName, roleNameAbbreviation, canContainData));
                continue;
            }
            assert (roleName.equals(role.roleName())) : "role name [" + roleName + "] does not match role [" + role.roleName() + "]";
            assert (roleNameAbbreviation.equals(role.roleNameAbbreviation())) : "role name abbreviation [" + roleName + "] does not match role [" + role.roleNameAbbreviation() + "]";
            roles.add(role);
        }
        this.roles = Collections.unmodifiableSortedSet(new TreeSet(roles));
        Version version = in.readVersion();
        this.nodeInfo = new NodeInfo(nodeName, nodeId, ephemeralId, hostName, hostAddress, address, attributes, version);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.nodeInfo.writeTo(out);
        out.writeVInt(this.roles.size());
        for (NodeRole role : this.roles) {
            NodeRole compatibleRole = role.getCompatibilityRole(out.getVersion());
            out.writeString(compatibleRole.roleName());
            out.writeString(compatibleRole.roleNameAbbreviation());
            out.writeBoolean(compatibleRole.canContainData());
        }
        out.writeVersion(this.getVersion());
    }

    public TransportAddress getAddress() {
        return this.nodeInfo.getAddress();
    }

    public String getId() {
        return this.nodeInfo.getId();
    }

    public String getEphemeralId() {
        return this.nodeInfo.getEphemeralId();
    }

    public String getName() {
        return this.nodeInfo.getName();
    }

    public Map<String, String> getAttributes() {
        return this.nodeInfo.getAttributes();
    }

    public boolean isDataNode() {
        return this.roles.stream().anyMatch(NodeRole::canContainData);
    }

    public boolean isClusterManagerNode() {
        return this.roles.contains(NodeRole.MASTER_ROLE) || this.roles.contains(NodeRole.CLUSTER_MANAGER_ROLE);
    }

    @Deprecated
    public boolean isMasterNode() {
        return this.isClusterManagerNode();
    }

    public boolean isIngestNode() {
        return this.roles.contains(NodeRole.INGEST_ROLE);
    }

    public boolean isRemoteClusterClient() {
        return this.roles.contains(NodeRole.REMOTE_CLUSTER_CLIENT_ROLE);
    }

    public boolean isSearchNode() {
        return this.roles.contains(NodeRole.SEARCH_ROLE);
    }

    public boolean isRemoteStoreNode() {
        return this.getAttributes().keySet().stream().anyMatch(key -> key.startsWith("remote_store"));
    }

    public Set<NodeRole> getRoles() {
        return this.roles;
    }

    public Version getVersion() {
        return this.nodeInfo.getVersion();
    }

    public String getHostName() {
        return this.nodeInfo.getHostName();
    }

    public String getHostAddress() {
        return this.nodeInfo.getHostAddress();
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryNode that = (DiscoveryNode)o;
        return this.nodeInfo.equals(that.nodeInfo);
    }

    public int hashCode() {
        return this.nodeInfo.hashCode();
    }

    public String toString() {
        Map<String, String> attributes;
        StringBuilder sb = new StringBuilder();
        String nodeName = this.nodeInfo.getName();
        if (nodeName.length() > 0) {
            sb.append('{').append(nodeName).append('}');
        }
        sb.append('{').append(this.nodeInfo.getId()).append('}');
        sb.append('{').append(this.nodeInfo.getEphemeralId()).append('}');
        sb.append('{').append(this.nodeInfo.getHostName()).append('}');
        sb.append('{').append(this.nodeInfo.getAddress()).append('}');
        if (!this.roles.isEmpty()) {
            sb.append('{');
            this.roles.stream().map(NodeRole::roleNameAbbreviation).sorted().forEach(sb::append);
            sb.append('}');
        }
        if (!(attributes = this.nodeInfo.getAttributes()).isEmpty()) {
            sb.append(attributes.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("remote_store")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return sb.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return NodeInfo.toXContent(this.nodeInfo, builder, params);
    }

    private static Map<String, NodeRole> rolesToMap(Stream<NodeRole> roles) {
        return Collections.unmodifiableMap(roles.collect(Collectors.toMap(NodeRole::roleName, Function.identity())));
    }

    public static NodeRole getRoleFromRoleName(String roleName) {
        String lowerCasedRoleName = Objects.requireNonNull(roleName).toLowerCase(Locale.ROOT);
        if (roleMap.containsKey(lowerCasedRoleName)) {
            return roleMap.get(lowerCasedRoleName);
        }
        return new NodeRole.DynamicRole(lowerCasedRoleName, lowerCasedRoleName, false);
    }

    public static Set<NodeRole> getPossibleRoles() {
        return Collections.unmodifiableSet(new HashSet<NodeRole>(roleMap.values()));
    }

    public static void setAdditionalRoles(Set<NodeRole> additionalRoles) {
        assert (additionalRoles.stream().allMatch(r -> r.legacySetting() == null || r.legacySetting().isDeprecated())) : additionalRoles;
        Map<String, NodeRole> roleNameToPossibleRoles = DiscoveryNode.rolesToMap(Stream.concat(NodeRole.BUILT_IN_ROLES.stream(), additionalRoles.stream()));
        Map roleNameAbbreviationToPossibleRoles = Collections.unmodifiableMap(roleNameToPossibleRoles.values().stream().collect(Collectors.toMap(NodeRole::roleNameAbbreviation, Function.identity())));
        assert (roleNameToPossibleRoles.size() == roleNameAbbreviationToPossibleRoles.size()) : "roles by name [" + String.valueOf(roleNameToPossibleRoles) + "], roles by name abbreviation [" + String.valueOf(roleNameAbbreviationToPossibleRoles) + "]";
        roleMap = roleNameToPossibleRoles;
    }

    public static void setDeprecatedMasterRole() {
        HashMap<String, NodeRole> modifiableRoleMap = new HashMap<String, NodeRole>(roleMap);
        modifiableRoleMap.put(NodeRole.MASTER_ROLE.roleName(), NodeRole.MASTER_ROLE);
        roleMap = Collections.unmodifiableMap(modifiableRoleMap);
    }

    public static Set<String> getPossibleRoleNames() {
        return roleMap.keySet();
    }
}

