/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.node;

import io.skylite.LegacyESVersion;
import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.common.Booleans;
import io.skylite.common.annotation.PublicApi;
import io.skylite.core.cluster.remote.RemoteClusterConnectionSettings;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

@PublicApi(since="1.0.0")
public abstract class NodeRole
implements Comparable<NodeRole> {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(NodeRole.class);
    public static final String MASTER_ROLE_DEPRECATION_MESSAGE = "Assigning [master] role in setting [node.roles] is deprecated. To promote inclusive language, please use [cluster_manager] role instead.";
    private final String roleName;
    private final String roleNameAbbreviation;
    private final boolean canContainData;
    private final boolean isKnownRole;
    private final boolean isDynamicRole;
    public static final NodeRole DATA_ROLE = new NodeRole("data", "d", true){

        @Override
        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting("node.data", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
        }
    };
    public static final NodeRole INGEST_ROLE = new NodeRole("ingest", "i"){

        @Override
        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting("node.ingest", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
        }
    };
    @Deprecated
    public static final NodeRole MASTER_ROLE = new NodeRole("master", "m"){

        @Override
        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting("node.master", false, Setting.Property.Deprecated, Setting.Property.NodeScope);
        }

        @Override
        public void validateRole(List<NodeRole> roles) {
            deprecationLogger.deprecate("node_role_master", NodeRole.MASTER_ROLE_DEPRECATION_MESSAGE, new Object[0]);
        }
    };
    public static final NodeRole CLUSTER_MANAGER_ROLE = new NodeRole("cluster_manager", "m"){

        @Override
        public Setting<Boolean> legacySetting() {
            return null;
        }

        @Override
        public NodeRole getCompatibilityRole(Version nodeVersion) {
            if (nodeVersion.onOrAfter(OpenSearchVersion.V_2_0_0)) {
                return this;
            }
            return MASTER_ROLE;
        }

        @Override
        public void validateRole(List<NodeRole> roles) {
            if (roles.contains(MASTER_ROLE)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "The two roles [%s, %s] can not be assigned together to a node. %s", MASTER_ROLE.roleName(), CLUSTER_MANAGER_ROLE.roleName(), NodeRole.MASTER_ROLE_DEPRECATION_MESSAGE));
            }
        }

        @Override
        public boolean isEnabledByDefault(Settings settings) {
            return !Booleans.isBoolean((String)settings.get("node.master"));
        }
    };
    public static final NodeRole REMOTE_CLUSTER_CLIENT_ROLE = new NodeRole("remote_cluster_client", "r"){

        @Override
        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting("node.remote_cluster_client", RemoteClusterConnectionSettings.ENABLE_REMOTE_CLUSTERS, Setting.Property.Deprecated, Setting.Property.NodeScope);
        }
    };
    public static final NodeRole SEARCH_ROLE = new NodeRole("search", "s", true){

        @Override
        public Setting<Boolean> legacySetting() {
            return null;
        }
    };
    public static SortedSet<NodeRole> BUILT_IN_ROLES = Collections.unmodifiableSortedSet(new TreeSet<NodeRole>(Arrays.asList(DATA_ROLE, INGEST_ROLE, CLUSTER_MANAGER_ROLE, REMOTE_CLUSTER_CLIENT_ROLE, SEARCH_ROLE)));
    public static final Version REMOTE_CLUSTER_CLIENT_ROLE_VERSION = LegacyESVersion.fromString("7.8.0");
    static SortedSet<NodeRole> LEGACY_ROLES = Collections.unmodifiableSortedSet(new TreeSet<NodeRole>(Arrays.asList(DATA_ROLE, INGEST_ROLE, MASTER_ROLE)));

    public final String roleName() {
        return this.roleName;
    }

    public final String roleNameAbbreviation() {
        return this.roleNameAbbreviation;
    }

    public final boolean canContainData() {
        return this.canContainData;
    }

    public final boolean isKnownRole() {
        return this.isKnownRole;
    }

    public final boolean isDynamicRole() {
        return this.isDynamicRole;
    }

    public boolean isEnabledByDefault(Settings settings) {
        return this.legacySetting() != null && this.legacySetting().get(settings) != false;
    }

    protected NodeRole(String roleName, String roleNameAbbreviation) {
        this(roleName, roleNameAbbreviation, false);
    }

    protected NodeRole(String roleName, String roleNameAbbreviation, boolean canContainData) {
        this(true, false, roleName, roleNameAbbreviation, canContainData);
    }

    private NodeRole(boolean isKnownRole, boolean isDynamicRole, String roleName, String roleNameAbbreviation, boolean canContainData) {
        this.isKnownRole = isKnownRole;
        this.isDynamicRole = isDynamicRole;
        this.roleName = Objects.requireNonNull(roleName).toLowerCase(Locale.ROOT);
        this.roleNameAbbreviation = Objects.requireNonNull(roleNameAbbreviation).toLowerCase(Locale.ROOT);
        this.canContainData = canContainData;
    }

    public abstract Setting<Boolean> legacySetting();

    public NodeRole getCompatibilityRole(Version nodeVersion) {
        return this;
    }

    public void validateRole(List<NodeRole> roles) {
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeRole that = (NodeRole)o;
        return this.roleName.equals(that.roleName) && this.roleNameAbbreviation.equals(that.roleNameAbbreviation) && this.canContainData == that.canContainData && this.isKnownRole == that.isKnownRole && this.isDynamicRole == that.isDynamicRole;
    }

    public final int hashCode() {
        return Objects.hash(this.isKnownRole, this.isDynamicRole, this.roleName(), this.roleNameAbbreviation(), this.canContainData());
    }

    @Override
    public final int compareTo(NodeRole o) {
        return this.roleName.compareTo(o.roleName);
    }

    public final String toString() {
        return "NodeRole{roleName='" + this.roleName + "', roleNameAbbreviation='" + this.roleNameAbbreviation + "', canContainData=" + this.canContainData + (this.isKnownRole ? "" : ", isKnownRole=false") + (this.isDynamicRole ? "" : ", isDynamicRole=false") + "}";
    }

    @Deprecated
    public boolean isClusterManager() {
        return this.equals(CLUSTER_MANAGER_ROLE) || this.equals(MASTER_ROLE);
    }

    public static class DynamicRole
    extends NodeRole {
        public DynamicRole(String roleName, String roleNameAbbreviation, boolean canContainData) {
            super(false, true, roleName, roleNameAbbreviation, canContainData);
        }

        @Override
        public Setting<Boolean> legacySetting() {
            return null;
        }
    }

    public static class UnknownRole
    extends NodeRole {
        public UnknownRole(String roleName, String roleNameAbbreviation, boolean canContainData) {
            super(false, false, roleName, roleNameAbbreviation, canContainData);
        }

        @Override
        public Setting<Boolean> legacySetting() {
            assert (false);
            return Setting.boolSetting("node. " + this.roleName(), false, Setting.Property.NodeScope);
        }
    }
}

