/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.routing;

import io.skylite.common.Nullable;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.WeightedRoutingMetadata;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.routing.GroupShardsIterator;
import io.skylite.core.cluster.routing.IndexRoutingTable;
import io.skylite.core.cluster.routing.IndexShardRoutingTable;
import io.skylite.core.cluster.routing.Murmur3HashFunction;
import io.skylite.core.cluster.routing.Preference;
import io.skylite.core.cluster.routing.PreferenceBasedSearchNotAllowedException;
import io.skylite.core.cluster.routing.RoutingTable;
import io.skylite.core.cluster.routing.ShardIterator;
import io.skylite.core.cluster.routing.WeightedRoutingUtils;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDeciderSettings;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.Strings;
import io.skylite.core.index.IndexModuleSettings;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.store.IndexStoreSettings;
import io.skylite.core.node.ResponseCollectorService;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OperationRouting {
    public static final Setting<Boolean> USE_ADAPTIVE_REPLICA_SELECTION_SETTING = Setting.boolSetting("cluster.routing.use_adaptive_replica_selection", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String IGNORE_AWARENESS_ATTRIBUTES = "cluster.search.ignore_awareness_attributes";
    public static final Setting<Boolean> IGNORE_AWARENESS_ATTRIBUTES_SETTING = Setting.boolSetting("cluster.search.ignore_awareness_attributes", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> WEIGHTED_ROUTING_DEFAULT_WEIGHT = Setting.doubleSetting("cluster.routing.weighted.default_weight", 1.0, 1.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> WEIGHTED_ROUTING_FAILOPEN_ENABLED = Setting.boolSetting("cluster.routing.weighted.fail_open", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> STRICT_WEIGHTED_SHARD_ROUTING_ENABLED = Setting.boolSetting("cluster.routing.weighted.strict", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> IGNORE_WEIGHTED_SHARD_ROUTING = Setting.boolSetting("cluster.routing.ignore_weighted_routing", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static final List<Preference> WEIGHTED_ROUTING_RESTRICTED_PREFERENCES = Arrays.asList(Preference.ONLY_NODES, Preference.PREFER_NODES);
    private volatile List<String> awarenessAttributes;
    private volatile boolean useAdaptiveReplicaSelection;
    private volatile boolean ignoreAwarenessAttr;
    private volatile double weightedRoutingDefaultWeight;
    private volatile boolean isFailOpenEnabled;
    private volatile boolean isStrictWeightedShardRouting;
    private volatile boolean ignoreWeightedRouting;
    private static final Map<String, Set<String>> EMPTY_ROUTING = Collections.emptyMap();

    public OperationRouting(Settings settings, ClusterSettings clusterSettings) {
        this.ignoreAwarenessAttr = clusterSettings.get(IGNORE_AWARENESS_ATTRIBUTES_SETTING);
        this.awarenessAttributes = AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
        this.useAdaptiveReplicaSelection = USE_ADAPTIVE_REPLICA_SELECTION_SETTING.get(settings);
        this.weightedRoutingDefaultWeight = WEIGHTED_ROUTING_DEFAULT_WEIGHT.get(settings);
        this.isFailOpenEnabled = WEIGHTED_ROUTING_FAILOPEN_ENABLED.get(settings);
        this.isStrictWeightedShardRouting = STRICT_WEIGHTED_SHARD_ROUTING_ENABLED.get(settings);
        this.ignoreWeightedRouting = IGNORE_WEIGHTED_SHARD_ROUTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(USE_ADAPTIVE_REPLICA_SELECTION_SETTING, this::setUseAdaptiveReplicaSelection);
        clusterSettings.addSettingsUpdateConsumer(IGNORE_AWARENESS_ATTRIBUTES_SETTING, this::setIgnoreAwarenessAttributes);
        clusterSettings.addSettingsUpdateConsumer(WEIGHTED_ROUTING_DEFAULT_WEIGHT, this::setWeightedRoutingDefaultWeight);
        clusterSettings.addSettingsUpdateConsumer(WEIGHTED_ROUTING_FAILOPEN_ENABLED, this::setFailOpenEnabled);
        clusterSettings.addSettingsUpdateConsumer(STRICT_WEIGHTED_SHARD_ROUTING_ENABLED, this::setStrictWeightedShardRouting);
        clusterSettings.addSettingsUpdateConsumer(IGNORE_WEIGHTED_SHARD_ROUTING, this::setIgnoreWeightedRouting);
    }

    void setUseAdaptiveReplicaSelection(boolean useAdaptiveReplicaSelection) {
        this.useAdaptiveReplicaSelection = useAdaptiveReplicaSelection;
    }

    void setIgnoreAwarenessAttributes(boolean ignoreAwarenessAttributes) {
        this.ignoreAwarenessAttr = ignoreAwarenessAttributes;
    }

    void setWeightedRoutingDefaultWeight(double weightedRoutingDefaultWeight) {
        this.weightedRoutingDefaultWeight = weightedRoutingDefaultWeight;
    }

    void setFailOpenEnabled(boolean isFailOpenEnabled) {
        this.isFailOpenEnabled = isFailOpenEnabled;
    }

    void setStrictWeightedShardRouting(boolean strictWeightedShardRouting) {
        this.isStrictWeightedShardRouting = strictWeightedShardRouting;
    }

    void setIgnoreWeightedRouting(boolean isWeightedRoundRobinEnabled) {
        this.ignoreWeightedRouting = isWeightedRoundRobinEnabled;
    }

    public boolean isIgnoreAwarenessAttr() {
        return this.ignoreAwarenessAttr;
    }

    List<String> getAwarenessAttributes() {
        return this.awarenessAttributes;
    }

    private void setAwarenessAttributes(List<String> awarenessAttributes) {
        this.awarenessAttributes = awarenessAttributes;
    }

    public boolean ignoreAwarenessAttributes() {
        return this.awarenessAttributes.isEmpty() || this.ignoreAwarenessAttr;
    }

    public double getWeightedRoutingDefaultWeight() {
        return this.weightedRoutingDefaultWeight;
    }

    public ShardIterator indexShards(ClusterState clusterState, String index, String id, @Nullable String routing) {
        return this.shards(clusterState, index, id, routing).shardsIt();
    }

    public ShardIterator getShards(ClusterState clusterState, String index, String id, @Nullable String routing, @Nullable String preference) {
        return this.preferenceActiveShardIterator(this.shards(clusterState, index, id, routing), clusterState.nodes().getLocalNodeId(), clusterState.nodes(), preference, null, null, clusterState.getMetadata().weightedRoutingMetadata());
    }

    public ShardIterator getShards(ClusterState clusterState, String index, int shardId, @Nullable String preference) {
        IndexShardRoutingTable indexShard = clusterState.getRoutingTable().shardRoutingTable(index, shardId);
        return this.preferenceActiveShardIterator(indexShard, clusterState.nodes().getLocalNodeId(), clusterState.nodes(), preference, null, null, clusterState.metadata().weightedRoutingMetadata());
    }

    public GroupShardsIterator<ShardIterator> searchShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing, @Nullable String preference) {
        return this.searchShards(clusterState, concreteIndices, routing, preference, null, null);
    }

    public GroupShardsIterator<ShardIterator> searchShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing, @Nullable String preference, @Nullable ResponseCollectorService collectorService, @Nullable Map<String, Long> nodeCounts) {
        Set<IndexShardRoutingTable> shards = this.computeTargetedShards(clusterState, concreteIndices, routing);
        HashSet<ShardIterator> set = new HashSet<ShardIterator>(shards.size());
        for (IndexShardRoutingTable shard : shards) {
            ShardIterator iterator;
            IndexMetadata indexMetadataForShard = this.indexMetadata(clusterState, shard.shardId().getIndex().getName());
            if (IndexModuleSettings.Type.REMOTE_SNAPSHOT.match(indexMetadataForShard.getSettings().get(IndexStoreSettings.INDEX_STORE_TYPE_SETTING.getKey())) && (preference == null || preference.isEmpty())) {
                preference = Preference.PRIMARY.type();
            }
            if ((iterator = this.preferenceActiveShardIterator(shard, clusterState.nodes().getLocalNodeId(), clusterState.nodes(), preference, collectorService, nodeCounts, clusterState.metadata().weightedRoutingMetadata())) == null) continue;
            set.add(iterator);
        }
        return GroupShardsIterator.sortAndCreate(new ArrayList(set));
    }

    public static ShardIterator getShards(ClusterState clusterState, ShardId shardId) {
        IndexShardRoutingTable shard = clusterState.routingTable().shardRoutingTable(shardId);
        return shard.activeInitializingShardsRandomIt();
    }

    private Set<IndexShardRoutingTable> computeTargetedShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing) {
        routing = routing == null ? EMPTY_ROUTING : routing;
        HashSet<IndexShardRoutingTable> set = new HashSet<IndexShardRoutingTable>();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index);
            IndexMetadata indexMetadata = this.indexMetadata(clusterState, index);
            Set<String> effectiveRouting = routing.get(index);
            if (effectiveRouting != null) {
                for (String r : effectiveRouting) {
                    int routingPartitionSize = indexMetadata.getRoutingPartitionSize();
                    for (int partitionOffset = 0; partitionOffset < routingPartitionSize; ++partitionOffset) {
                        set.add(RoutingTable.shardRoutingTable(indexRouting, OperationRouting.calculateScaledShardId(indexMetadata, r, partitionOffset)));
                    }
                }
                continue;
            }
            for (IndexShardRoutingTable indexShard : indexRouting) {
                set.add(indexShard);
            }
        }
        return set;
    }

    private ShardIterator preferenceActiveShardIterator(IndexShardRoutingTable indexShard, String localNodeId, DiscoveryNodes nodes, @Nullable String preference, @Nullable ResponseCollectorService collectorService, @Nullable Map<String, Long> nodeCounts, @Nullable WeightedRoutingMetadata weightedRoutingMetadata) {
        if (preference == null || preference.isEmpty()) {
            return this.shardRoutings(indexShard, nodes, collectorService, nodeCounts, weightedRoutingMetadata);
        }
        if (preference.charAt(0) == '_') {
            Preference preferenceType = Preference.parse(preference);
            if (preferenceType == Preference.SHARDS) {
                int index = preference.indexOf(124);
                String shards = index == -1 ? preference.substring(Preference.SHARDS.type().length() + 1) : preference.substring(Preference.SHARDS.type().length() + 1, index);
                String[] ids = Strings.splitStringByCommaToArray(shards);
                boolean found = false;
                for (String id : ids) {
                    if (Integer.parseInt(id) != indexShard.shardId().id()) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
                if (index == -1 || index == preference.length() - 1) {
                    return this.shardRoutings(indexShard, nodes, collectorService, nodeCounts, weightedRoutingMetadata);
                }
                preference = preference.substring(index + 1);
            }
            preferenceType = Preference.parse(preference);
            this.checkPreferenceBasedRoutingAllowed(preferenceType, weightedRoutingMetadata);
            switch (preferenceType) {
                case PREFER_NODES: {
                    Set<String> nodesIds = Arrays.stream(preference.substring(Preference.PREFER_NODES.type().length() + 1).split(",")).collect(Collectors.toSet());
                    return indexShard.preferNodeActiveInitializingShardsIt(nodesIds);
                }
                case LOCAL: {
                    return indexShard.preferNodeActiveInitializingShardsIt(Collections.singleton(localNodeId));
                }
                case PRIMARY: {
                    return indexShard.primaryActiveInitializingShardIt();
                }
                case REPLICA: {
                    return indexShard.replicaActiveInitializingShardIt();
                }
                case PRIMARY_FIRST: {
                    return indexShard.primaryFirstActiveInitializingShardsIt();
                }
                case REPLICA_FIRST: {
                    return indexShard.replicaFirstActiveInitializingShardsIt();
                }
                case ONLY_LOCAL: {
                    return indexShard.onlyNodeActiveInitializingShardsIt(localNodeId);
                }
                case ONLY_NODES: {
                    String nodeAttributes = preference.substring(Preference.ONLY_NODES.type().length() + 1);
                    return indexShard.onlyNodeSelectorActiveInitializingShardsIt(nodeAttributes.split(","), nodes);
                }
            }
            throw new IllegalArgumentException("unknown preference [" + String.valueOf((Object)preferenceType) + "]");
        }
        int routingHash = Murmur3HashFunction.hash(preference);
        routingHash = 31 * routingHash + indexShard.shardId().hashCode();
        if (WeightedRoutingUtils.shouldPerformStrictWeightedRouting(this.isStrictWeightedShardRouting, this.ignoreWeightedRouting, weightedRoutingMetadata)) {
            return indexShard.activeInitializingShardsWeightedIt(weightedRoutingMetadata.getWeightedRouting(), nodes, this.getWeightedRoutingDefaultWeight(), this.isFailOpenEnabled, routingHash);
        }
        if (this.ignoreAwarenessAttributes()) {
            return indexShard.activeInitializingShardsIt(routingHash);
        }
        return indexShard.preferAttributesActiveInitializingShardsIt(this.awarenessAttributes, nodes, routingHash);
    }

    private ShardIterator shardRoutings(IndexShardRoutingTable indexShard, DiscoveryNodes nodes, @Nullable ResponseCollectorService collectorService, @Nullable Map<String, Long> nodeCounts, @Nullable WeightedRoutingMetadata weightedRoutingMetadata) {
        if (WeightedRoutingUtils.shouldPerformWeightedRouting(this.ignoreWeightedRouting, weightedRoutingMetadata)) {
            return indexShard.activeInitializingShardsWeightedIt(weightedRoutingMetadata.getWeightedRouting(), nodes, this.getWeightedRoutingDefaultWeight(), this.isFailOpenEnabled, null);
        }
        if (this.ignoreAwarenessAttributes()) {
            if (this.useAdaptiveReplicaSelection) {
                return indexShard.activeInitializingShardsRankedIt(collectorService, nodeCounts);
            }
            return indexShard.activeInitializingShardsRandomIt();
        }
        return indexShard.preferAttributesActiveInitializingShardsIt(this.awarenessAttributes, nodes);
    }

    protected IndexRoutingTable indexRoutingTable(ClusterState clusterState, String index) {
        IndexRoutingTable indexRouting = clusterState.routingTable().index(index);
        if (indexRouting == null) {
            throw new IndexNotFoundException(index);
        }
        return indexRouting;
    }

    protected IndexMetadata indexMetadata(ClusterState clusterState, String index) {
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null) {
            throw new IndexNotFoundException(index);
        }
        return indexMetadata;
    }

    protected IndexShardRoutingTable shards(ClusterState clusterState, String index, String id, String routing) {
        int shardId = OperationRouting.generateShardId(this.indexMetadata(clusterState, index), id, routing);
        return clusterState.getRoutingTable().shardRoutingTable(index, shardId);
    }

    public ShardId shardId(ClusterState clusterState, String index, String id, @Nullable String routing) {
        IndexMetadata indexMetadata = this.indexMetadata(clusterState, index);
        return new ShardId(indexMetadata.getIndex(), OperationRouting.generateShardId(indexMetadata, id, routing));
    }

    public static int generateShardId(IndexMetadata indexMetadata, @Nullable String id, @Nullable String routing) {
        String effectiveRouting;
        if (routing == null) {
            assert (!indexMetadata.isRoutingPartitionedIndex()) : "A routing value is required for gets from a partitioned index";
            effectiveRouting = id;
        } else {
            effectiveRouting = routing;
        }
        int partitionOffset = indexMetadata.isRoutingPartitionedIndex() ? Math.floorMod(Murmur3HashFunction.hash(id), indexMetadata.getRoutingPartitionSize()) : 0;
        return OperationRouting.calculateScaledShardId(indexMetadata, effectiveRouting, partitionOffset);
    }

    private static int calculateScaledShardId(IndexMetadata indexMetadata, String effectiveRouting, int partitionOffset) {
        int hash = Murmur3HashFunction.hash(effectiveRouting) + partitionOffset;
        return Math.floorMod(hash, indexMetadata.getRoutingNumShards()) / indexMetadata.getRoutingFactor();
    }

    private void checkPreferenceBasedRoutingAllowed(Preference preference, @Nullable WeightedRoutingMetadata weightedRoutingMetadata) {
        if (WeightedRoutingUtils.shouldPerformStrictWeightedRouting(this.isStrictWeightedShardRouting, this.ignoreWeightedRouting, weightedRoutingMetadata) && WEIGHTED_ROUTING_RESTRICTED_PREFERENCES.contains((Object)preference)) {
            throw new PreferenceBasedSearchNotAllowedException("Preference type based routing not allowed with strict weighted shard routing enabled", new Object[0]);
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(USE_ADAPTIVE_REPLICA_SELECTION_SETTING, IGNORE_AWARENESS_ATTRIBUTES_SETTING, WEIGHTED_ROUTING_DEFAULT_WEIGHT, WEIGHTED_ROUTING_FAILOPEN_ENABLED, STRICT_WEIGHTED_SHARD_ROUTING_ENABLED, IGNORE_WEIGHTED_SHARD_ROUTING);
        }
    }
}

