/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.routing;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.common.Nullable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.repositories.IndexId;
import io.skylite.core.snapshots.Snapshot;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Objects;

public abstract class RecoverySource
implements Writeable,
ToXContentObject {
    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", (Object)this.getType());
        this.addAdditionalFields(builder, params);
        return builder.endObject();
    }

    public void addAdditionalFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public static RecoverySource readFrom(StreamInput in) throws IOException {
        Type type = Type.values()[in.readByte()];
        switch (type.ordinal()) {
            case 0: {
                return EmptyStoreRecoverySource.INSTANCE;
            }
            case 1: {
                return ExistingStoreRecoverySource.read(in);
            }
            case 2: {
                return PeerRecoverySource.INSTANCE;
            }
            case 3: {
                return new SnapshotRecoverySource(in);
            }
            case 4: {
                return LocalShardsRecoverySource.INSTANCE;
            }
            case 5: {
                return new RemoteStoreRecoverySource(in);
            }
        }
        throw new IllegalArgumentException("unknown recovery type: " + type.name());
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeByte((byte)this.getType().ordinal());
        this.writeAdditionalFields(out);
    }

    protected void writeAdditionalFields(StreamOutput out) throws IOException {
    }

    public abstract Type getType();

    public boolean shouldBootstrapNewHistoryUUID() {
        return false;
    }

    public boolean expectEmptyRetentionLeases() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecoverySource that = (RecoverySource)o;
        return this.getType() == that.getType();
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public static enum Type {
        EMPTY_STORE,
        EXISTING_STORE,
        PEER,
        SNAPSHOT,
        LOCAL_SHARDS,
        REMOTE_STORE;

    }

    public static final class EmptyStoreRecoverySource
    extends RecoverySource {
        public static final EmptyStoreRecoverySource INSTANCE = new EmptyStoreRecoverySource();

        @Override
        public Type getType() {
            return Type.EMPTY_STORE;
        }

        public String toString() {
            return "new shard recovery";
        }
    }

    public static final class ExistingStoreRecoverySource
    extends RecoverySource {
        public static final String FORCED_ALLOCATION_ID = "_forced_allocation_";
        public static final ExistingStoreRecoverySource INSTANCE = new ExistingStoreRecoverySource(false);
        public static final ExistingStoreRecoverySource FORCE_STALE_PRIMARY_INSTANCE = new ExistingStoreRecoverySource(true);
        private final boolean bootstrapNewHistoryUUID;

        private ExistingStoreRecoverySource(boolean bootstrapNewHistoryUUID) {
            this.bootstrapNewHistoryUUID = bootstrapNewHistoryUUID;
        }

        private static ExistingStoreRecoverySource read(StreamInput in) throws IOException {
            return in.readBoolean() ? FORCE_STALE_PRIMARY_INSTANCE : INSTANCE;
        }

        @Override
        public void addAdditionalFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("bootstrap_new_history_uuid", this.bootstrapNewHistoryUUID);
        }

        @Override
        protected void writeAdditionalFields(StreamOutput out) throws IOException {
            out.writeBoolean(this.bootstrapNewHistoryUUID);
        }

        @Override
        public boolean shouldBootstrapNewHistoryUUID() {
            return this.bootstrapNewHistoryUUID;
        }

        @Override
        public Type getType() {
            return Type.EXISTING_STORE;
        }

        public String toString() {
            return "existing store recovery; bootstrap_history_uuid=" + this.bootstrapNewHistoryUUID;
        }

        @Override
        public boolean expectEmptyRetentionLeases() {
            return this.bootstrapNewHistoryUUID;
        }
    }

    public static class PeerRecoverySource
    extends RecoverySource {
        public static final PeerRecoverySource INSTANCE = new PeerRecoverySource();

        private PeerRecoverySource() {
        }

        @Override
        public Type getType() {
            return Type.PEER;
        }

        public String toString() {
            return "peer recovery";
        }

        @Override
        public boolean expectEmptyRetentionLeases() {
            return false;
        }
    }

    public static class SnapshotRecoverySource
    extends RecoverySource {
        public static final String NO_API_RESTORE_UUID = "_no_api_";
        private final String restoreUUID;
        private final Snapshot snapshot;
        private final IndexId index;
        private final Version version;
        private final boolean isSearchableSnapshot;
        private final boolean remoteStoreIndexShallowCopy;
        private final String sourceRemoteStoreRepository;

        public SnapshotRecoverySource(String restoreUUID, Snapshot snapshot, Version version, IndexId indexId) {
            this(restoreUUID, snapshot, version, indexId, false, false, null);
        }

        public SnapshotRecoverySource(String restoreUUID, Snapshot snapshot, Version version, IndexId indexId, boolean isSearchableSnapshot, boolean remoteStoreIndexShallowCopy, @Nullable String sourceRemoteStoreRepository) {
            this.restoreUUID = restoreUUID;
            this.snapshot = Objects.requireNonNull(snapshot);
            this.version = Objects.requireNonNull(version);
            this.index = Objects.requireNonNull(indexId);
            this.isSearchableSnapshot = isSearchableSnapshot;
            this.remoteStoreIndexShallowCopy = remoteStoreIndexShallowCopy;
            this.sourceRemoteStoreRepository = sourceRemoteStoreRepository;
        }

        SnapshotRecoverySource(StreamInput in) throws IOException {
            this.restoreUUID = in.readString();
            this.snapshot = new Snapshot(in);
            this.version = in.readVersion();
            this.index = new IndexId(in);
            this.isSearchableSnapshot = in.getVersion().onOrAfter(OpenSearchVersion.V_2_7_0) ? in.readBoolean() : false;
            if (in.getVersion().onOrAfter(OpenSearchVersion.V_2_9_0)) {
                this.remoteStoreIndexShallowCopy = in.readBoolean();
                this.sourceRemoteStoreRepository = in.readOptionalString();
            } else {
                this.remoteStoreIndexShallowCopy = false;
                this.sourceRemoteStoreRepository = null;
            }
        }

        public String restoreUUID() {
            return this.restoreUUID;
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public IndexId index() {
            return this.index;
        }

        public Version version() {
            return this.version;
        }

        public boolean isSearchableSnapshot() {
            return this.isSearchableSnapshot;
        }

        public String sourceRemoteStoreRepository() {
            return this.sourceRemoteStoreRepository;
        }

        public boolean remoteStoreIndexShallowCopy() {
            return this.remoteStoreIndexShallowCopy;
        }

        @Override
        protected void writeAdditionalFields(StreamOutput out) throws IOException {
            out.writeString(this.restoreUUID);
            this.snapshot.writeTo(out);
            out.writeVersion(this.version);
            this.index.writeTo(out);
            if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_7_0)) {
                out.writeBoolean(this.isSearchableSnapshot);
            }
            if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_9_0)) {
                out.writeBoolean(this.remoteStoreIndexShallowCopy);
                out.writeOptionalString(this.sourceRemoteStoreRepository);
            }
        }

        @Override
        public Type getType() {
            return Type.SNAPSHOT;
        }

        @Override
        public void addAdditionalFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("repository", this.snapshot.getRepository()).field("snapshot", this.snapshot.getSnapshotId().getName()).field("version", this.version.toString()).field("index", this.index.getName()).field("restoreUUID", this.restoreUUID).field("isSearchableSnapshot", this.isSearchableSnapshot).field("remoteStoreIndexShallowCopy", this.remoteStoreIndexShallowCopy).field("sourceRemoteStoreRepository", this.sourceRemoteStoreRepository);
        }

        public String toString() {
            return "snapshot recovery [" + this.restoreUUID + "] from " + String.valueOf(this.snapshot);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SnapshotRecoverySource that = (SnapshotRecoverySource)o;
            return this.restoreUUID.equals(that.restoreUUID) && this.snapshot.equals(that.snapshot) && this.index.equals(that.index) && this.version.equals(that.version) && this.isSearchableSnapshot == that.isSearchableSnapshot && this.remoteStoreIndexShallowCopy == that.remoteStoreIndexShallowCopy && this.sourceRemoteStoreRepository != null ? this.sourceRemoteStoreRepository.equals(that.sourceRemoteStoreRepository) : that.sourceRemoteStoreRepository == null;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.restoreUUID, this.snapshot, this.index, this.version, this.isSearchableSnapshot, this.remoteStoreIndexShallowCopy, this.sourceRemoteStoreRepository);
        }
    }

    public static class LocalShardsRecoverySource
    extends RecoverySource {
        public static final LocalShardsRecoverySource INSTANCE = new LocalShardsRecoverySource();

        private LocalShardsRecoverySource() {
        }

        @Override
        public Type getType() {
            return Type.LOCAL_SHARDS;
        }

        public String toString() {
            return "local shards recovery";
        }
    }

    public static class RemoteStoreRecoverySource
    extends RecoverySource {
        private final String restoreUUID;
        private final IndexId index;
        private final Version version;

        public RemoteStoreRecoverySource(String restoreUUID, Version version, IndexId indexId) {
            this.restoreUUID = restoreUUID;
            this.version = Objects.requireNonNull(version);
            this.index = Objects.requireNonNull(indexId);
        }

        RemoteStoreRecoverySource(StreamInput in) throws IOException {
            this.restoreUUID = in.readString();
            this.version = in.readVersion();
            this.index = new IndexId(in);
        }

        public String restoreUUID() {
            return this.restoreUUID;
        }

        public IndexId index() {
            return this.index;
        }

        public Version version() {
            return this.version;
        }

        @Override
        protected void writeAdditionalFields(StreamOutput out) throws IOException {
            out.writeString(this.restoreUUID);
            out.writeVersion(this.version);
            this.index.writeTo(out);
        }

        @Override
        public Type getType() {
            return Type.REMOTE_STORE;
        }

        @Override
        public void addAdditionalFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("version", this.version.toString()).field("index", this.index.getName()).field("restoreUUID", this.restoreUUID);
        }

        public String toString() {
            return "remote store recovery [" + this.restoreUUID + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteStoreRecoverySource that = (RemoteStoreRecoverySource)o;
            return this.restoreUUID.equals(that.restoreUUID) && this.index.equals(that.index) && this.version.equals(that.version);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.restoreUUID, this.index, this.version);
        }

        @Override
        public boolean expectEmptyRetentionLeases() {
            return false;
        }
    }
}

