/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.routing;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.Nullable;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public final class UnassignedInfo
implements ToXContentFragment,
Writeable {
    public static final DateFormatter DATE_TIME_FORMATTER = DateFormatter.forPattern("date_optional_time").withZone(ZoneOffset.UTC);
    public static final Setting<TimeValue> INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING = Setting.positiveTimeSetting("index.unassigned.node_left.delayed_timeout", TimeValue.timeValueMinutes((long)1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    private final Reason reason;
    private final long unassignedTimeMillis;
    private final long unassignedTimeNanos;
    private final boolean delayed;
    private final String message;
    private final Exception failure;
    private final int failedAllocations;
    private final Set<String> failedNodeIds;
    private final AllocationStatus lastAllocationStatus;

    public UnassignedInfo(Reason reason, String message) {
        this(reason, message, null, reason == Reason.ALLOCATION_FAILED ? 1 : 0, System.nanoTime(), System.currentTimeMillis(), false, AllocationStatus.NO_ATTEMPT, Collections.emptySet());
    }

    public UnassignedInfo(Reason reason, @Nullable String message, @Nullable Exception failure, int failedAllocations, long unassignedTimeNanos, long unassignedTimeMillis, boolean delayed, AllocationStatus lastAllocationStatus, Set<String> failedNodeIds) {
        this.reason = Objects.requireNonNull(reason);
        this.unassignedTimeMillis = unassignedTimeMillis;
        this.unassignedTimeNanos = unassignedTimeNanos;
        this.delayed = delayed;
        this.message = message;
        this.failure = failure;
        this.failedAllocations = failedAllocations;
        this.lastAllocationStatus = Objects.requireNonNull(lastAllocationStatus);
        this.failedNodeIds = Collections.unmodifiableSet(failedNodeIds);
        assert (failedAllocations > 0 == (reason == Reason.ALLOCATION_FAILED)) : "failedAllocations: " + failedAllocations + " for reason " + String.valueOf((Object)reason);
        assert (message != null || failure == null) : "provide a message if a failure exception is provided";
        assert (!delayed || reason == Reason.NODE_LEFT) : "shard can only be delayed if it is unassigned due to a node leaving";
    }

    public UnassignedInfo(StreamInput in) throws IOException {
        this.reason = Reason.values()[in.readByte()];
        this.unassignedTimeMillis = in.readLong();
        this.unassignedTimeNanos = System.nanoTime();
        this.delayed = in.readBoolean();
        this.message = in.readOptionalString();
        this.failure = in.readException();
        this.failedAllocations = in.readVInt();
        this.lastAllocationStatus = AllocationStatus.readFrom(in);
        this.failedNodeIds = Collections.unmodifiableSet(in.readSet(StreamInput::readString));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte((byte)this.reason.ordinal());
        out.writeLong(this.unassignedTimeMillis);
        out.writeBoolean(this.delayed);
        out.writeOptionalString(this.message);
        out.writeException(this.failure);
        out.writeVInt(this.failedAllocations);
        this.lastAllocationStatus.writeTo(out);
        out.writeCollection(this.failedNodeIds, StreamOutput::writeString);
    }

    public int getNumFailedAllocations() {
        return this.failedAllocations;
    }

    public boolean isDelayed() {
        return this.delayed;
    }

    public Reason getReason() {
        return this.reason;
    }

    public long getUnassignedTimeInMillis() {
        return this.unassignedTimeMillis;
    }

    public long getUnassignedTimeInNanos() {
        return this.unassignedTimeNanos;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public Exception getFailure() {
        return this.failure;
    }

    @Nullable
    public String getDetails() {
        if (this.message == null) {
            return null;
        }
        return this.message + (String)(this.failure == null ? "" : ", failure " + SkyliteExceptionsHelper.detailedMessage(this.failure));
    }

    public AllocationStatus getLastAllocationStatus() {
        return this.lastAllocationStatus;
    }

    public Set<String> getFailedNodeIds() {
        return this.failedNodeIds;
    }

    public long getRemainingDelay(long nanoTimeNow, Settings indexSettings) {
        long delayTimeoutNanos = INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.get(indexSettings).nanos();
        assert (nanoTimeNow >= this.unassignedTimeNanos);
        return Math.max(0L, delayTimeoutNanos - (nanoTimeNow - this.unassignedTimeNanos));
    }

    public String shortSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("[reason=").append((Object)this.reason).append("]");
        sb.append(", at[").append(DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(this.unassignedTimeMillis))).append("]");
        if (this.failedAllocations > 0) {
            sb.append(", failed_attempts[").append(this.failedAllocations).append("]");
        }
        if (!this.failedNodeIds.isEmpty()) {
            sb.append(", failed_nodes[").append(this.failedNodeIds).append("]");
        }
        sb.append(", delayed=").append(this.delayed);
        String details = this.getDetails();
        if (details != null) {
            sb.append(", details[").append(details).append("]");
        }
        sb.append(", allocation_status[").append(this.lastAllocationStatus.value()).append("]");
        return sb.toString();
    }

    public String toString() {
        return "unassigned_info[" + this.shortSummary() + "]";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("unassigned_info");
        builder.field("reason", (Object)this.reason);
        builder.field("at", DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(this.unassignedTimeMillis)));
        if (this.failedAllocations > 0) {
            builder.field("failed_attempts", this.failedAllocations);
        }
        if (!this.failedNodeIds.isEmpty()) {
            builder.field("failed_nodes", this.failedNodeIds);
        }
        builder.field("delayed", this.delayed);
        String details = this.getDetails();
        if (details != null) {
            builder.field("details", details);
        }
        builder.field("allocation_status", this.lastAllocationStatus.value());
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnassignedInfo that = (UnassignedInfo)o;
        if (this.unassignedTimeMillis != that.unassignedTimeMillis) {
            return false;
        }
        if (this.delayed != that.delayed) {
            return false;
        }
        if (this.failedAllocations != that.failedAllocations) {
            return false;
        }
        if (this.reason != that.reason) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (this.lastAllocationStatus != that.lastAllocationStatus) {
            return false;
        }
        if (!Objects.equals(this.failure, that.failure)) {
            return false;
        }
        return this.failedNodeIds.equals(that.failedNodeIds);
    }

    public int hashCode() {
        int result = this.reason.hashCode();
        result = 31 * result + Boolean.hashCode(this.delayed);
        result = 31 * result + Integer.hashCode(this.failedAllocations);
        result = 31 * result + Long.hashCode(this.unassignedTimeMillis);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.failure != null ? this.failure.hashCode() : 0);
        result = 31 * result + this.lastAllocationStatus.hashCode();
        result = 31 * result + this.failedNodeIds.hashCode();
        return result;
    }

    public static enum Reason {
        INDEX_CREATED,
        CLUSTER_RECOVERED,
        INDEX_REOPENED,
        DANGLING_INDEX_IMPORTED,
        NEW_INDEX_RESTORED,
        EXISTING_INDEX_RESTORED,
        REPLICA_ADDED,
        ALLOCATION_FAILED,
        NODE_LEFT,
        REROUTE_CANCELLED,
        REINITIALIZED,
        REALLOCATED_REPLICA,
        PRIMARY_FAILED,
        FORCED_EMPTY_PRIMARY,
        MANUAL_ALLOCATION,
        INDEX_CLOSED;

    }

    public static enum AllocationStatus implements Writeable
    {
        DECIDERS_NO(0),
        NO_VALID_SHARD_COPY(1),
        DECIDERS_THROTTLED(2),
        FETCHING_SHARD_DATA(3),
        DELAYED_ALLOCATION(4),
        NO_ATTEMPT(5);

        private final byte id;

        private AllocationStatus(byte id) {
            this.id = id;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.id);
        }

        public static AllocationStatus readFrom(StreamInput in) throws IOException {
            byte id = in.readByte();
            switch (id) {
                case 0: {
                    return DECIDERS_NO;
                }
                case 1: {
                    return NO_VALID_SHARD_COPY;
                }
                case 2: {
                    return DECIDERS_THROTTLED;
                }
                case 3: {
                    return FETCHING_SHARD_DATA;
                }
                case 4: {
                    return DELAYED_ALLOCATION;
                }
                case 5: {
                    return NO_ATTEMPT;
                }
            }
            throw new IllegalArgumentException("Unknown AllocationStatus value [" + id + "]");
        }

        public static AllocationStatus fromDecision(Decision.Type decision) {
            Objects.requireNonNull(decision);
            switch (decision) {
                case NO: {
                    return DECIDERS_NO;
                }
                case THROTTLE: {
                    return DECIDERS_THROTTLED;
                }
            }
            throw new IllegalArgumentException("no allocation attempt from decision[" + String.valueOf(decision) + "]");
        }

        public String value() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING);
        }
    }
}

