/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.routing.allocation;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.Nullable;
import io.skylite.core.cluster.routing.ShardRouting;

public class FailedShard {
    private final ShardRouting routingEntry;
    private final String message;
    private final Exception failure;
    private final boolean markAsStale;

    public FailedShard(ShardRouting routingEntry, String message, @Nullable Exception failure, boolean markAsStale) {
        assert (routingEntry.assignedToNode()) : "only assigned shards can be failed " + String.valueOf(routingEntry);
        this.routingEntry = routingEntry;
        this.message = message;
        this.failure = failure;
        this.markAsStale = markAsStale;
    }

    public String toString() {
        return "failed shard, shard " + String.valueOf(this.routingEntry) + ", message [" + this.message + "], failure [" + (this.failure == null ? "null" : SkyliteExceptionsHelper.detailedMessage(this.failure)) + "], markAsStale [" + this.markAsStale + "]";
    }

    public ShardRouting getRoutingEntry() {
        return this.routingEntry;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public Exception getFailure() {
        return this.failure;
    }

    public boolean markAsStale() {
        return this.markAsStale;
    }
}

