/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.routing.allocation;

import io.skylite.core.cluster.routing.RoutingChangesObserver;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.UnassignedInfo;

public class RoutingNodesChangedObserver
implements RoutingChangesObserver {
    private boolean changed;

    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
        assert (unassignedShard.unassigned()) : "expected unassigned shard " + String.valueOf(unassignedShard);
        assert (initializedShard.initializing()) : "expected initializing shard " + String.valueOf(initializedShard);
        this.setChanged();
    }

    @Override
    public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
        assert (initializingShard.initializing()) : "expected initializing shard " + String.valueOf(initializingShard);
        assert (startedShard.started()) : "expected started shard " + String.valueOf(startedShard);
        this.setChanged();
    }

    @Override
    public void relocationStarted(ShardRouting startedShard, ShardRouting targetRelocatingShard) {
        assert (startedShard.started()) : "expected started shard " + String.valueOf(startedShard);
        assert (targetRelocatingShard.isRelocationTarget()) : "expected relocation target shard " + String.valueOf(targetRelocatingShard);
        this.setChanged();
    }

    @Override
    public void unassignedInfoUpdated(ShardRouting unassignedShard, UnassignedInfo newUnassignedInfo) {
        assert (unassignedShard.unassigned()) : "expected unassigned shard " + String.valueOf(unassignedShard);
        this.setChanged();
    }

    @Override
    public void shardFailed(ShardRouting failedShard, UnassignedInfo unassignedInfo) {
        assert (failedShard.assignedToNode()) : "expected assigned shard " + String.valueOf(failedShard);
        this.setChanged();
    }

    @Override
    public void relocationCompleted(ShardRouting removedRelocationSource) {
        assert (removedRelocationSource.relocating()) : "expected relocating shard " + String.valueOf(removedRelocationSource);
        this.setChanged();
    }

    @Override
    public void relocationSourceRemoved(ShardRouting removedReplicaRelocationSource) {
        assert (!removedReplicaRelocationSource.primary() && removedReplicaRelocationSource.isRelocationTarget()) : "expected replica relocation target shard " + String.valueOf(removedReplicaRelocationSource);
        this.setChanged();
    }

    @Override
    public void replicaPromoted(ShardRouting replicaShard) {
        assert (replicaShard.started() && !replicaShard.primary()) : "expected started replica shard " + String.valueOf(replicaShard);
        this.setChanged();
    }

    @Override
    public void initializedReplicaReinitialized(ShardRouting oldReplica, ShardRouting reinitializedReplica) {
        assert (oldReplica.initializing() && !oldReplica.primary()) : "expected initializing replica shard " + String.valueOf(oldReplica);
        assert (reinitializedReplica.initializing() && !reinitializedReplica.primary()) : "expected reinitialized replica shard " + String.valueOf(reinitializedReplica);
        assert (!oldReplica.allocationId().getId().equals(reinitializedReplica.allocationId().getId())) : "expected allocation id to change for reinitialized replica shard (old: " + String.valueOf(oldReplica) + " new: " + String.valueOf(reinitializedReplica) + ")";
        this.setChanged();
    }

    private void setChanged() {
        this.changed = true;
    }
}

