/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.routing.allocation.decider;

import io.skylite.core.cluster.node.DiscoveryNodeFilters;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;

public final class AllocationDeciderSettings {
    public static final Setting<List<String>> CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING = Setting.listSetting("cluster.routing.allocation.awareness.attributes", Collections.emptyList(), Function.identity(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Settings> CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING = Setting.groupSetting("cluster.routing.allocation.awareness.force.", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_RECOVERIES_SETTING = Setting.intSetting("cluster.routing.allocation.cluster_concurrent_recoveries", -1, -1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_REBALANCE_SETTING = Setting.intSetting("cluster.routing.allocation.cluster_concurrent_rebalance", 2, -1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Allocation> CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING = new Setting<Allocation>("cluster.routing.allocation.enable", Allocation.ALL.toString(), Allocation::parse, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Allocation> INDEX_ROUTING_ALLOCATION_ENABLE_SETTING = new Setting<Allocation>("index.routing.allocation.enable", Allocation.ALL.toString(), Allocation::parse, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Rebalance> CLUSTER_ROUTING_REBALANCE_ENABLE_SETTING = new Setting<Rebalance>("cluster.routing.rebalance.enable", Rebalance.ALL.toString(), Rebalance::parse, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Rebalance> INDEX_ROUTING_REBALANCE_ENABLE_SETTING = new Setting<Rebalance>("index.routing.rebalance.enable", Rebalance.ALL.toString(), Rebalance::parse, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final int DEFAULT_CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES = 2;
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING = new Setting<Integer>("cluster.routing.allocation.node_concurrent_recoveries", Integer.toString(2), s -> Setting.parseInt(s, 0, "cluster.routing.allocation.node_concurrent_recoveries"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING = new Setting<Integer>("cluster.routing.allocation.node_concurrent_outgoing_recoveries", CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING, s -> Setting.parseInt(s, 0, "cluster.routing.allocation.node_concurrent_outgoing_recoveries"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING = new Setting<Integer>("cluster.routing.allocation.node_concurrent_incoming_recoveries", CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING, s -> Setting.parseInt(s, 0, "cluster.routing.allocation.node_concurrent_incoming_recoveries"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final int DEFAULT_CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_RECOVERIES = 4;
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_REPLICAS_RECOVERIES_SETTING = Setting.intSetting("cluster.routing.allocation.node_initial_replicas_recoveries", 4, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES_SETTING = Setting.intSetting("cluster.routing.allocation.node_initial_primaries_recoveries", 4, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String CLUSTER_ROUTING_REQUIRE_GROUP_PREFIX = "cluster.routing.allocation.require";
    public static final Setting.AffixSetting<String> CLUSTER_ROUTING_REQUIRE_GROUP_SETTING = Setting.prefixKeySetting("cluster.routing.allocation.require.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.NodeScope));
    public static final String CLUSTER_ROUTING_INCLUDE_GROUP_PREFIX = "cluster.routing.allocation.include";
    public static final Setting.AffixSetting<String> CLUSTER_ROUTING_INCLUDE_GROUP_SETTING = Setting.prefixKeySetting("cluster.routing.allocation.include.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.NodeScope));
    public static final String CLUSTER_ROUTING_EXCLUDE_GROUP_PREFIX = "cluster.routing.allocation.exclude";
    public static final Setting.AffixSetting<String> CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING = Setting.prefixKeySetting("cluster.routing.allocation.exclude.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.NodeScope));
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_PROVISIONED_CAPACITY_SETTING = Setting.intSetting("cluster.routing.allocation.load_awareness.provisioned_capacity", -1, -1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_SKEW_FACTOR_SETTING = Setting.doubleSetting("cluster.routing.allocation.load_awareness.skew_factor", 50.0, -1.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_ALLOW_UNASSIGNED_PRIMARIES_SETTING = Setting.boolSetting("cluster.routing.allocation.load_awareness.allow_unassigned_primaries", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_FLAT_SKEW_SETTING = Setting.intSetting("cluster.routing.allocation.load_awareness.flat_skew", 2, 2, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING = Setting.boolSetting("cluster.routing.allocation.same_shard.host", false, Setting.Property.Dynamic, Setting.Property.NodeScope);

    public static enum Allocation {
        NONE,
        NEW_PRIMARIES,
        PRIMARIES,
        ALL;


        public static Allocation parse(String strValue) {
            if (strValue == null) {
                return null;
            }
            strValue = strValue.toUpperCase(Locale.ROOT);
            try {
                return Allocation.valueOf(strValue);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Illegal allocation.enable value [" + strValue + "]");
            }
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Rebalance {
        NONE,
        PRIMARIES,
        REPLICAS,
        ALL;


        public static Rebalance parse(String strValue) {
            if (strValue == null) {
                return null;
            }
            strValue = strValue.toUpperCase(Locale.ROOT);
            try {
                return Rebalance.valueOf(strValue);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Illegal rebalance.enable value [" + strValue + "]");
            }
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING, CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_REBALANCE_SETTING, CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_RECOVERIES_SETTING, CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING, CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_PROVISIONED_CAPACITY_SETTING, CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_SKEW_FACTOR_SETTING, CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_ALLOW_UNASSIGNED_PRIMARIES_SETTING, CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_FLAT_SKEW_SETTING, CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES_SETTING, CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_REPLICAS_RECOVERIES_SETTING, CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING, CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING, CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING, CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING, CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING, CLUSTER_ROUTING_INCLUDE_GROUP_SETTING, CLUSTER_ROUTING_REBALANCE_ENABLE_SETTING, CLUSTER_ROUTING_REQUIRE_GROUP_SETTING, INDEX_ROUTING_REBALANCE_ENABLE_SETTING, INDEX_ROUTING_ALLOCATION_ENABLE_SETTING);
        }
    }
}

