/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.routing.allocation.decider;

import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDecider;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.index.remote.RemoteStoreSettings;
import io.skylite.core.node.RemoteStoreNodeService;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import java.util.Locale;

public class RemoteStoreMigrationAllocationDecider
extends AllocationDecider {
    public static final String NAME = "remote_store_migration";
    private RemoteStoreNodeService.Direction migrationDirection;
    private RemoteStoreNodeService.CompatibilityMode compatibilityMode;
    private boolean remoteStoreBackedIndex;

    public RemoteStoreMigrationAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.migrationDirection = RemoteStoreNodeService.MIGRATION_DIRECTION_SETTING.get(settings);
        this.compatibilityMode = RemoteStoreNodeService.REMOTE_STORE_COMPATIBILITY_MODE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(RemoteStoreNodeService.MIGRATION_DIRECTION_SETTING, this::setMigrationDirection);
        clusterSettings.addSettingsUpdateConsumer(RemoteStoreNodeService.REMOTE_STORE_COMPATIBILITY_MODE_SETTING, this::setCompatibilityMode);
    }

    private void setMigrationDirection(RemoteStoreNodeService.Direction migrationDirection) {
        this.migrationDirection = migrationDirection;
    }

    private void setCompatibilityMode(RemoteStoreNodeService.CompatibilityMode compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        DiscoveryNode targetNode = node.node();
        if (this.compatibilityMode.equals((Object)RemoteStoreNodeService.CompatibilityMode.STRICT)) {
            return allocation.decision(Decision.YES, NAME, this.getDecisionDetails(true, shardRouting, targetNode, " for strict compatibility mode"), new Object[0]);
        }
        if (!this.migrationDirection.equals((Object)RemoteStoreNodeService.Direction.REMOTE_STORE)) {
            return allocation.decision(Decision.YES, NAME, this.getDecisionDetails(true, shardRouting, targetNode, " for non remote_store direction"), new Object[0]);
        }
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
        if (RemoteStoreSettings.INDEX_REMOTE_STORE_ENABLED_SETTING.exists(indexMetadata.getSettings())) {
            this.remoteStoreBackedIndex = RemoteStoreSettings.INDEX_REMOTE_STORE_ENABLED_SETTING.get(indexMetadata.getSettings());
        }
        if (this.remoteStoreBackedIndex && !targetNode.isRemoteStoreNode()) {
            String reason = String.format(Locale.ROOT, " because a remote store backed index's shard copy can only be %s to a remote node", !shardRouting.assignedToNode() ? "allocated" : "relocated");
            return allocation.decision(Decision.NO, NAME, this.getDecisionDetails(false, shardRouting, targetNode, reason), new Object[0]);
        }
        if (shardRouting.primary()) {
            return this.primaryShardDecision(shardRouting, targetNode, allocation);
        }
        return this.replicaShardDecision(shardRouting, targetNode, allocation);
    }

    private Decision primaryShardDecision(ShardRouting primaryShardRouting, DiscoveryNode targetNode, RoutingAllocation allocation) {
        if (!targetNode.isRemoteStoreNode()) {
            return allocation.decision(Decision.NO, NAME, this.getDecisionDetails(false, primaryShardRouting, targetNode, ""), new Object[0]);
        }
        return allocation.decision(Decision.YES, NAME, this.getDecisionDetails(true, primaryShardRouting, targetNode, ""), new Object[0]);
    }

    private Decision replicaShardDecision(ShardRouting replicaShardRouting, DiscoveryNode targetNode, RoutingAllocation allocation) {
        if (targetNode.isRemoteStoreNode()) {
            ShardRouting primaryShardRouting = allocation.routingNodes().activePrimary(replicaShardRouting.shardId());
            boolean primaryHasMigratedToRemote = false;
            if (primaryShardRouting != null) {
                DiscoveryNode primaryShardNode = allocation.nodes().getNodes().get(primaryShardRouting.currentNodeId());
                primaryHasMigratedToRemote = primaryShardNode.isRemoteStoreNode();
            }
            if (!primaryHasMigratedToRemote) {
                return allocation.decision(Decision.NO, NAME, this.getDecisionDetails(false, replicaShardRouting, targetNode, " since primary shard copy is not yet migrated to remote"), new Object[0]);
            }
            return allocation.decision(Decision.YES, NAME, this.getDecisionDetails(true, replicaShardRouting, targetNode, " since primary shard copy has been migrated to remote"), new Object[0]);
        }
        return allocation.decision(Decision.YES, NAME, this.getDecisionDetails(true, replicaShardRouting, targetNode, ""), new Object[0]);
    }

    private String getDecisionDetails(boolean isYes, ShardRouting shardRouting, DiscoveryNode targetNode, String reason) {
        return String.format(Locale.ROOT, "[%s migration_direction]: %s shard copy %s be %s to a %s node%s", this.migrationDirection.direction, shardRouting.primary() ? "primary" : "replica", isYes ? "can" : "can not", !shardRouting.assignedToNode() ? "allocated" : "relocated", targetNode.isRemoteStoreNode() ? "remote" : "non-remote", reason);
    }
}

