/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.service;

import io.skylite.common.annotation.PublicApi;
import io.skylite.common.lifecycle.AbstractLifecycleComponent;
import io.skylite.core.cluster.ClusterName;
import io.skylite.core.cluster.NodeConnectionsService;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.OperationRouting;
import io.skylite.core.cluster.routing.RerouteService;
import io.skylite.core.cluster.service.ClusterManagerService;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.LocalNodeClusterManagerListener;
import io.skylite.core.cluster.service.MasterService;
import io.skylite.core.cluster.service.NodeShutdownListener;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateApplier;
import io.skylite.core.cluster.state.ClusterStateApplierService;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateTaskExecutor;
import io.skylite.core.cluster.state.ClusterStateTaskListener;
import io.skylite.core.index.pressure.IndexingPressureService;
import io.skylite.core.monitor.JvmInfo;
import io.skylite.core.node.ResponseCollectorService;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.CommonSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.threadpool.ThreadPool;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@PublicApi(since="1.0.0")
public class ClusterService
extends AbstractLifecycleComponent {
    private final ClusterManagerService clusterManagerService;
    private final ClusterStateApplierService clusterStateApplierService;
    public static final Setting.AffixSetting<String> USER_DEFINED_METADATA = Setting.prefixKeySetting("cluster.metadata.", key -> Setting.simpleString(key, Setting.Property.Dynamic, Setting.Property.NodeScope));
    private final Settings settings;
    private final ClusterName clusterName;
    private final OperationRouting operationRouting;
    private final ClusterSettings clusterSettings;
    private final String nodeName;
    private RerouteService rerouteService;
    private IndexingPressureService indexingPressureService;
    private NodeShutdownListener nodeShutdownListener;
    private JvmInfo jvmInfo;

    public ClusterService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool) {
        this(settings, clusterSettings, new ClusterManagerService(settings, clusterSettings, threadPool), new ClusterStateApplierService(CommonSettings.NODE_NAME_SETTING.get(settings), settings, clusterSettings, threadPool));
    }

    public ClusterService(Settings settings, ClusterSettings clusterSettings, ClusterManagerService clusterManagerService, ClusterStateApplierService clusterStateApplierService) {
        this.settings = settings;
        this.nodeName = CommonSettings.NODE_NAME_SETTING.get(settings);
        this.clusterManagerService = clusterManagerService;
        this.operationRouting = new OperationRouting(settings, clusterSettings);
        this.clusterSettings = clusterSettings;
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.clusterSettings.addAffixUpdateConsumer(USER_DEFINED_METADATA, (first, second) -> {}, (first, second) -> {});
        this.clusterStateApplierService = clusterStateApplierService;
    }

    public synchronized void setNodeConnectionsService(NodeConnectionsService nodeConnectionsService) {
        this.clusterStateApplierService.setNodeConnectionsService(nodeConnectionsService);
    }

    public void setRerouteService(RerouteService rerouteService) {
        assert (this.rerouteService == null) : "RerouteService is already set";
        this.rerouteService = rerouteService;
    }

    public RerouteService getRerouteService() {
        assert (this.rerouteService != null) : "RerouteService not set";
        return this.rerouteService;
    }

    protected synchronized void doStart() {
        this.clusterStateApplierService.start();
        this.clusterManagerService.start();
    }

    protected synchronized void doStop() {
        this.clusterManagerService.stop();
        this.clusterStateApplierService.stop();
        if (this.nodeShutdownListener != null) {
            this.nodeShutdownListener.startNodeShutdown();
        }
    }

    protected synchronized void doClose() {
        this.clusterManagerService.close();
        this.clusterStateApplierService.close();
    }

    public JvmInfo getJvmInfo() {
        return this.jvmInfo;
    }

    public DiscoveryNode localNode() {
        DiscoveryNode localNode = this.state().getNodes().getLocalNode();
        if (localNode == null) {
            throw new IllegalStateException("No local node found. Is the node started?");
        }
        return localNode;
    }

    public OperationRouting operationRouting() {
        return this.operationRouting;
    }

    public ClusterState state() {
        return this.clusterStateApplierService.state();
    }

    public void addHighPriorityApplier(ClusterStateApplier applier) {
        this.clusterStateApplierService.addHighPriorityApplier(applier);
    }

    public void addLowPriorityApplier(ClusterStateApplier applier) {
        this.clusterStateApplierService.addLowPriorityApplier(applier);
    }

    public void addStateApplier(ClusterStateApplier applier) {
        this.clusterStateApplierService.addStateApplier(applier);
    }

    public void addNodeShutdownListener(NodeShutdownListener listener) {
        this.nodeShutdownListener = listener;
    }

    public void setJvmInfo(JvmInfo jvmInfo) {
        this.jvmInfo = jvmInfo;
    }

    public void removeApplier(ClusterStateApplier applier) {
        this.clusterStateApplierService.removeApplier(applier);
    }

    public void addListener(ClusterStateListener listener) {
        this.clusterStateApplierService.addListener(listener);
    }

    public void removeListener(ClusterStateListener listener) {
        this.clusterStateApplierService.removeListener(listener);
    }

    public void addLocalNodeClusterManagerListener(LocalNodeClusterManagerListener listener) {
        this.clusterStateApplierService.addLocalNodeClusterManagerListener(listener);
    }

    public ClusterManagerService getClusterManagerService() {
        return this.clusterManagerService;
    }

    @Deprecated
    public MasterService getMasterService() {
        return this.clusterManagerService;
    }

    public void setIndexingPressureService(IndexingPressureService indexingPressureService) {
        this.indexingPressureService = indexingPressureService;
    }

    public IndexingPressureService getIndexingPressureService() {
        return this.indexingPressureService;
    }

    public ClusterStateApplierService getClusterApplierService() {
        return this.clusterStateApplierService;
    }

    public static boolean assertClusterOrClusterManagerStateThread() {
        assert (Thread.currentThread().getName().contains("clusterApplierService#updateTask") || Thread.currentThread().getName().contains("clusterManagerService#updateTask")) : "not called from the master/cluster state update thread";
        return true;
    }

    @Deprecated
    public static boolean assertClusterOrMasterStateThread() {
        return ClusterService.assertClusterOrClusterManagerStateThread();
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public final String getNodeName() {
        return this.nodeName;
    }

    public ClusterManagerTaskThrottler.ThrottlingKey registerClusterManagerTask(String taskKey, boolean throttlingEnabled) {
        return this.clusterManagerService.registerClusterManagerTask(taskKey, throttlingEnabled);
    }

    public <T extends ClusterStateTaskConfig & ClusterStateTaskExecutor<T>> void submitStateUpdateTask(String source, T updateTask) {
        this.submitStateUpdateTask(source, updateTask, updateTask, updateTask, (ClusterStateTaskListener)updateTask);
    }

    public <T> void submitStateUpdateTask(String source, T task, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor, ClusterStateTaskListener listener) {
        this.submitStateUpdateTasks(source, Collections.singletonMap(task, listener), config, executor);
    }

    public <T> void submitStateUpdateTasks(String source, Map<T, ClusterStateTaskListener> tasks, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor) {
        this.clusterManagerService.submitStateUpdateTasks(source, tasks, config, executor);
    }

    public ResponseCollectorService addNewResponseCollectorServiceListener() {
        ResponseCollectorService rcs = new ResponseCollectorService();
        this.addListener(rcs);
        return rcs;
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(USER_DEFINED_METADATA);
        }
    }
}

