/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.service;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.Priority;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.text.Text;
import java.io.IOException;

public class PendingClusterTask
implements Writeable {
    private long insertOrder;
    private Priority priority;
    private Text source;
    private long timeInQueue;
    private boolean executing;

    public PendingClusterTask(StreamInput in) throws IOException {
        this.insertOrder = in.readVLong();
        this.priority = Priority.readFrom(in);
        this.source = in.readText();
        this.timeInQueue = in.readLong();
        this.executing = in.readBoolean();
    }

    public PendingClusterTask(long insertOrder, Priority priority, Text source, long timeInQueue, boolean executing) {
        assert (timeInQueue >= 0L) : "got a negative timeInQueue [" + timeInQueue + "]";
        assert (insertOrder >= 0L) : "got a negative insertOrder [" + insertOrder + "]";
        this.insertOrder = insertOrder;
        this.priority = priority;
        this.source = source;
        this.timeInQueue = timeInQueue;
        this.executing = executing;
    }

    public long getInsertOrder() {
        return this.insertOrder;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Text getSource() {
        return this.source;
    }

    public long getTimeInQueueInMillis() {
        return this.timeInQueue;
    }

    public TimeValue getTimeInQueue() {
        return new TimeValue(this.getTimeInQueueInMillis());
    }

    public boolean isExecuting() {
        return this.executing;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.insertOrder);
        Priority.writeTo(this.priority, out);
        out.writeText(this.source);
        out.writeLong(this.timeInQueue);
        out.writeBoolean(this.executing);
    }
}

