/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.state;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class PersistedStateStats
implements Writeable,
ToXContentObject {
    private String statsName;
    private AtomicLong totalTimeInMillis = new AtomicLong(0L);
    private AtomicLong failedCount = new AtomicLong(0L);
    private AtomicLong successCount = new AtomicLong(0L);
    private Map<String, AtomicLong> extendedFields = new HashMap<String, AtomicLong>();

    public PersistedStateStats(String statsName) {
        this.statsName = statsName;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.successCount.get());
        out.writeVLong(this.failedCount.get());
        out.writeVLong(this.totalTimeInMillis.get());
        if (this.extendedFields.size() > 0) {
            out.writeBoolean(true);
            out.writeVInt(this.extendedFields.size());
            for (Map.Entry<String, AtomicLong> extendedField : this.extendedFields.entrySet()) {
                out.writeString(extendedField.getKey());
                out.writeVLong(extendedField.getValue().get());
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public PersistedStateStats(StreamInput in) throws IOException {
        this.successCount = new AtomicLong(in.readVLong());
        this.failedCount = new AtomicLong(in.readVLong());
        this.totalTimeInMillis = new AtomicLong(in.readVLong());
        if (in.readBoolean()) {
            int extendedFieldsSize = in.readVInt();
            this.extendedFields = new HashMap<String, AtomicLong>();
            for (int fieldNumber = 0; fieldNumber < extendedFieldsSize; ++fieldNumber) {
                this.extendedFields.put(in.readString(), new AtomicLong(in.readVLong()));
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.statsName);
        builder.field("success_count", this.getSuccessCount());
        builder.field("failed_count", this.getFailedCount());
        builder.field("total_time_in_millis", this.getTotalTimeInMillis());
        if (this.extendedFields.size() > 0) {
            for (Map.Entry<String, AtomicLong> extendedField : this.extendedFields.entrySet()) {
                builder.field(extendedField.getKey(), extendedField.getValue().get());
            }
        }
        builder.endObject();
        return builder;
    }

    public void stateFailed() {
        this.failedCount.incrementAndGet();
    }

    public void stateSucceeded() {
        this.successCount.incrementAndGet();
    }

    public void stateTook(long timeTakenInUpload) {
        this.totalTimeInMillis.addAndGet(timeTakenInUpload);
    }

    public long getTotalTimeInMillis() {
        return this.totalTimeInMillis.get();
    }

    public long getFailedCount() {
        return this.failedCount.get();
    }

    public long getSuccessCount() {
        return this.successCount.get();
    }

    protected void addToExtendedFields(String extendedField, AtomicLong extendedFieldValue) {
        this.extendedFields.put(extendedField, extendedFieldValue);
    }

    static final class Fields {
        static final String SUCCESS_COUNT = "success_count";
        static final String TOTAL_TIME_IN_MILLIS = "total_time_in_millis";
        static final String FAILED_COUNT = "failed_count";

        Fields() {
        }
    }
}

