/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentLocation;
import java.io.IOException;

public class ParsingException
extends SkyliteException {
    protected static final int UNKNOWN_POSITION = -1;
    private final int lineNumber;
    private final int columnNumber;

    public ParsingException(XContentLocation contentLocation, String msg, Object ... args) {
        this(contentLocation, msg, null, args);
    }

    public ParsingException(XContentLocation contentLocation, String msg, Throwable cause, Object ... args) {
        super(msg, cause, args);
        int lineNumber = -1;
        int columnNumber = -1;
        if (contentLocation != null) {
            lineNumber = contentLocation.lineNumber;
            columnNumber = contentLocation.columnNumber;
        }
        this.columnNumber = columnNumber;
        this.lineNumber = lineNumber;
    }

    public ParsingException(int line, int col, String msg, Throwable cause) {
        super(msg, cause, new Object[0]);
        this.lineNumber = line;
        this.columnNumber = col;
    }

    public ParsingException(StreamInput in) throws IOException {
        super(in);
        this.lineNumber = in.readInt();
        this.columnNumber = in.readInt();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }

    @Override
    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.lineNumber != -1) {
            builder.field("line", this.lineNumber);
            builder.field("col", this.columnNumber);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.lineNumber);
        out.writeInt(this.columnNumber);
    }

    public static class Registration
    implements SkyliteExceptionProvider<ParsingException> {
        @Override
        public Class<ParsingException> getExceptionClass() {
            return ParsingException.class;
        }

        @Override
        public CheckedFunction<StreamInput, ParsingException, IOException> getConstructor() {
            return ParsingException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 40;
        }
    }
}

