/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.breaker;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.breaker.CircuitBreaker;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;

public class CircuitBreakingException
extends SkyliteException {
    private final long bytesWanted;
    private final long byteLimit;
    private final CircuitBreaker.Durability durability;

    public CircuitBreakingException(StreamInput in) throws IOException {
        super(in);
        this.byteLimit = in.readLong();
        this.bytesWanted = in.readLong();
        this.durability = in.readEnum(CircuitBreaker.Durability.class);
    }

    public CircuitBreakingException(String message, CircuitBreaker.Durability durability) {
        this(message, 0L, 0L, durability);
    }

    public CircuitBreakingException(String message, long bytesWanted, long byteLimit, CircuitBreaker.Durability durability) {
        super(message, new Object[0]);
        this.bytesWanted = bytesWanted;
        this.byteLimit = byteLimit;
        this.durability = durability;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.byteLimit);
        out.writeLong(this.bytesWanted);
        out.writeEnum(this.durability);
    }

    public long getBytesWanted() {
        return this.bytesWanted;
    }

    public long getByteLimit() {
        return this.byteLimit;
    }

    public CircuitBreaker.Durability getDurability() {
        return this.durability;
    }

    @Override
    public RestStatus status() {
        return RestStatus.TOO_MANY_REQUESTS;
    }

    @Override
    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("bytes_wanted", this.bytesWanted);
        builder.field("bytes_limit", this.byteLimit);
        builder.field("durability", (Object)this.durability);
    }

    public static class Registration
    implements SkyliteExceptionProvider<CircuitBreakingException> {
        @Override
        public Class<CircuitBreakingException> getExceptionClass() {
            return CircuitBreakingException.class;
        }

        @Override
        public CheckedFunction<StreamInput, CircuitBreakingException, IOException> getConstructor() {
            return CircuitBreakingException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 133;
        }
    }
}

