/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.concurrent;

import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.collect.Tuple;
import io.skylite.core.action.support.ContextPreservingActionListener;
import io.skylite.core.common.concurrent.BaseFuture;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.util.FutureUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public final class ListenableFuture<V>
extends BaseFuture<V>
implements ActionListener<V> {
    private volatile boolean done = false;
    private final List<Tuple<ActionListener<V>, ExecutorService>> listeners = new ArrayList<Tuple<ActionListener<V>, ExecutorService>>();

    public void addListener(ActionListener<V> listener, ExecutorService executor) {
        this.addListener(listener, executor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ActionListener<V> listener, ExecutorService executor, ThreadContext threadContext) {
        if (this.done) {
            this.notifyListener(listener, SkyliteExecutors.newDirectExecutorService());
        } else {
            boolean run;
            ListenableFuture listenableFuture = this;
            synchronized (listenableFuture) {
                if (this.done) {
                    run = true;
                } else {
                    Object wrappedListener = threadContext == null ? listener : ContextPreservingActionListener.wrapPreservingContext(listener, threadContext);
                    this.listeners.add(new Tuple(wrappedListener, (Object)executor));
                    run = false;
                }
            }
            if (run) {
                this.notifyListener(listener, SkyliteExecutors.newDirectExecutorService());
            }
        }
    }

    @Override
    protected synchronized void done(boolean ignored) {
        this.done = true;
        this.listeners.forEach(t -> this.notifyListener((ActionListener)t.v1(), (ExecutorService)t.v2()));
        this.listeners.clear();
    }

    private void notifyListener(ActionListener<V> listener, ExecutorService executorService) {
        try {
            executorService.execute((Runnable)new ActionRunnable<V>(listener){

                public void doRun() {
                    Object value = FutureUtils.get(ListenableFuture.this, 0L, TimeUnit.NANOSECONDS);
                    this.listener.onResponse(value);
                }

                public String toString() {
                    return "ListenableFuture notification";
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void onResponse(V v) {
        boolean set = this.set(v);
        if (!set) {
            throw new IllegalStateException("did not set value, value or exception already set?");
        }
    }

    public void onFailure(Exception e) {
        boolean set = this.setException(e);
        if (!set) {
            throw new IllegalStateException("did not set exception, value already set or exception already set?");
        }
    }
}

