/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject;

import io.skylite.core.common.inject.BindingProcessor;
import io.skylite.core.common.inject.InjectorImpl;
import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.ErrorsException;
import io.skylite.core.common.inject.internal.InternalContext;
import io.skylite.core.common.inject.internal.InternalFactory;
import io.skylite.core.common.inject.spi.Dependency;
import java.util.function.Supplier;

class BoundSupplierFactory<T>
implements InternalFactory<T>,
BindingProcessor.CreationListener {
    private final InjectorImpl injector;
    final Key<? extends Supplier<? extends T>> supplierKey;
    final Object source;
    private InternalFactory<? extends Supplier<? extends T>> supplierFactory;

    BoundSupplierFactory(InjectorImpl injector, Key<? extends Supplier<? extends T>> supplierKey, Object source) {
        this.injector = injector;
        this.supplierKey = supplierKey;
        this.source = source;
    }

    @Override
    public void notify(Errors errors) {
        try {
            this.supplierFactory = this.injector.getInternalFactory(this.supplierKey, errors.withSource(this.source));
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
    }

    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
        errors = errors.withSource(this.supplierKey);
        Supplier<T> supplier = this.supplierFactory.get(errors, context, dependency);
        try {
            return errors.checkForNull(supplier.get(), this.source, dependency);
        }
        catch (RuntimeException userException) {
            throw errors.errorInSupplier(userException).toException();
        }
    }

    public String toString() {
        return this.supplierKey.toString();
    }
}

