/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject;

import io.skylite.core.common.inject.ConstructionProxy;
import io.skylite.core.common.inject.MembersInjectorImpl;
import io.skylite.core.common.inject.SingleParameterInjector;
import io.skylite.core.common.inject.internal.ConstructionContext;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.ErrorsException;
import io.skylite.core.common.inject.internal.InternalContext;
import java.lang.reflect.InvocationTargetException;

class ConstructorInjector<T> {
    private final SingleParameterInjector<?>[] parameterInjectors;
    private final ConstructionProxy<T> constructionProxy;
    private final MembersInjectorImpl<T> membersInjector;

    ConstructorInjector(ConstructionProxy<T> constructionProxy, SingleParameterInjector<?>[] parameterInjectors, MembersInjectorImpl<T> membersInjector) {
        this.constructionProxy = constructionProxy;
        this.parameterInjectors = parameterInjectors;
        this.membersInjector = membersInjector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object construct(Errors errors, InternalContext context, Class<?> expectedType) throws ErrorsException {
        ConstructionContext constructionContext = context.getConstructionContext(this);
        if (constructionContext.isConstructing()) {
            return constructionContext.createProxy(errors, expectedType);
        }
        Object t = constructionContext.getCurrentReference();
        if (t != null) {
            return t;
        }
        try {
            Object parameters;
            constructionContext.startConstruction();
            try {
                parameters = SingleParameterInjector.getAll(errors, context, this.parameterInjectors);
                t = this.constructionProxy.newInstance(parameters);
                constructionContext.setProxyDelegates(t);
            }
            finally {
                constructionContext.finishConstruction();
            }
            constructionContext.setCurrentReference(t);
            this.membersInjector.injectMembers(t, errors, context);
            this.membersInjector.notifyListeners(t, errors);
            parameters = t;
            return parameters;
        }
        catch (InvocationTargetException userException) {
            Throwable cause = userException.getCause() != null ? userException.getCause() : userException;
            throw errors.withSource(this.constructionProxy.getInjectionPoint()).errorInjectingConstructor(cause).toException();
        }
        finally {
            constructionContext.removeCurrentReference();
        }
    }
}

