/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject;

import io.skylite.core.common.inject.ConfigurationException;
import io.skylite.core.common.inject.ConstructorInjector;
import io.skylite.core.common.inject.DefaultConstructionProxyFactory;
import io.skylite.core.common.inject.InjectorImpl;
import io.skylite.core.common.inject.MembersInjectorImpl;
import io.skylite.core.common.inject.SingleParameterInjector;
import io.skylite.core.common.inject.TypeLiteral;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.ErrorsException;
import io.skylite.core.common.inject.internal.FailableCache;
import io.skylite.core.common.inject.spi.InjectionPoint;

final class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<TypeLiteral<?>, ConstructorInjector<?>> cache = new FailableCache<TypeLiteral<?>, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(TypeLiteral<?> type, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(type, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    public <T> ConstructorInjector<T> get(TypeLiteral<T> key, Errors errors) throws ErrorsException {
        return this.cache.get(key, errors);
    }

    private <T> ConstructorInjector<T> createConstructor(TypeLiteral<T> type, Errors errors) throws ErrorsException {
        InjectionPoint injectionPoint;
        int numErrorsBefore = errors.size();
        try {
            injectionPoint = InjectionPoint.forConstructorOf(type);
        }
        catch (ConfigurationException e) {
            errors.merge(e.getErrorMessages());
            throw errors.toException();
        }
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<T> membersInjector = this.injector.membersInjectorStore.get(type, errors);
        DefaultConstructionProxyFactory factory = new DefaultConstructionProxyFactory(injectionPoint);
        errors.throwIfNewErrors(numErrorsBefore);
        return new ConstructorInjector(factory.create(), constructorParameterInjectors, membersInjector);
    }
}

