/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject;

import io.skylite.core.common.inject.Binding;
import io.skylite.core.common.inject.Injector;
import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.Scope;
import io.skylite.core.common.inject.State;
import io.skylite.core.common.inject.TypeLiteral;
import io.skylite.core.common.inject.WeakKeySet;
import io.skylite.core.common.inject.internal.BindingImpl;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.InstanceBindingImpl;
import io.skylite.core.common.inject.internal.InternalFactory;
import io.skylite.core.common.inject.internal.MatcherAndConverter;
import io.skylite.core.common.inject.internal.SourceProvider;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class InheritingState
implements State {
    private final Map<Key<?>, Binding<?>> explicitBindingsMutable = new LinkedHashMap();
    private final Map<Key<?>, Binding<?>> explicitBindings = Collections.unmodifiableMap(this.explicitBindingsMutable);
    private final Map<Class<? extends Annotation>, Scope> scopes = new HashMap<Class<? extends Annotation>, Scope>();
    private final List<MatcherAndConverter> converters = new ArrayList<MatcherAndConverter>();
    private WeakKeySet denylistedKeys = new WeakKeySet();
    private final Object lock = this;

    InheritingState() {
    }

    @Override
    public State parent() {
        return State.NONE;
    }

    @Override
    public <T> BindingImpl<T> getExplicitBinding(Key<T> key) {
        Binding<?> binding = this.explicitBindings.get(key);
        return binding != null ? (BindingImpl<T>)binding : State.NONE.getExplicitBinding(key);
    }

    @Override
    public Map<Key<?>, Binding<?>> getExplicitBindingsThisLevel() {
        return this.explicitBindings;
    }

    @Override
    public void putBinding(Key<?> key, BindingImpl<?> binding) {
        this.explicitBindingsMutable.put(key, binding);
    }

    @Override
    public Scope getScope(Class<? extends Annotation> annotationType) {
        Scope scope = this.scopes.get(annotationType);
        return scope != null ? scope : State.NONE.getScope(annotationType);
    }

    @Override
    public void putAnnotation(Class<? extends Annotation> annotationType, Scope scope) {
        this.scopes.put(annotationType, scope);
    }

    @Override
    public Iterable<MatcherAndConverter> getConvertersThisLevel() {
        return this.converters;
    }

    @Override
    public void addConverter(MatcherAndConverter matcherAndConverter) {
        this.converters.add(matcherAndConverter);
    }

    @Override
    public MatcherAndConverter getConverter(String stringValue, TypeLiteral<?> type, Errors errors, Object source) {
        MatcherAndConverter matchingConverter = null;
        for (State s = this; s != State.NONE; s = s.parent()) {
            for (MatcherAndConverter converter : s.getConvertersThisLevel()) {
                if (!converter.getTypeMatcher().matches(type)) continue;
                if (matchingConverter != null) {
                    errors.ambiguousTypeConversion(stringValue, source, type, matchingConverter, converter);
                }
                matchingConverter = converter;
            }
        }
        return matchingConverter;
    }

    @Override
    public void denylist(Key<?> key) {
        State.NONE.denylist(key);
        this.denylistedKeys.add(key);
    }

    @Override
    public boolean isDenylisted(Key<?> key) {
        return this.denylistedKeys.contains(key);
    }

    @Override
    public void clearDenylisted() {
        this.denylistedKeys = new WeakKeySet();
    }

    @Override
    public void makeAllBindingsToEagerSingletons(Injector injector) {
        LinkedHashMap x = new LinkedHashMap();
        for (Map.Entry<Key<?>, Binding<?>> entry : this.explicitBindingsMutable.entrySet()) {
            Key<?> key = entry.getKey();
            BindingImpl binding = (BindingImpl)entry.getValue();
            Object value = binding.getSupplier().get();
            x.put(key, new InstanceBindingImpl(injector, key, SourceProvider.UNKNOWN_SOURCE, new InternalFactory.Instance(value), Collections.emptySet(), value));
        }
        this.explicitBindingsMutable.clear();
        this.explicitBindingsMutable.putAll(x);
    }

    @Override
    public Object lock() {
        return this.lock;
    }
}

