/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject.internal;

import io.skylite.core.common.inject.Binder;
import io.skylite.core.common.inject.ConfigurationException;
import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.binder.AnnotatedBindingBuilder;
import io.skylite.core.common.inject.internal.AbstractBindingBuilder;
import io.skylite.core.common.inject.internal.BindingImpl;
import io.skylite.core.common.inject.internal.InstanceBindingImpl;
import io.skylite.core.common.inject.internal.LinkedBindingImpl;
import io.skylite.core.common.inject.internal.ProviderInstanceBindingImpl;
import io.skylite.core.common.inject.spi.Element;
import io.skylite.core.common.inject.spi.InjectionPoint;
import io.skylite.core.common.inject.spi.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class BindingBuilder<T>
extends AbstractBindingBuilder<T>
implements AnnotatedBindingBuilder<T> {
    public BindingBuilder(Binder binder, List<Element> elements, Object source, Key<T> key) {
        super(binder, elements, source, key);
    }

    @Override
    public BindingBuilder<T> to(Class<? extends T> implementation) {
        Key<? extends T> linkedKey = Key.get(implementation);
        Objects.requireNonNull(linkedKey, "linkedKey");
        this.checkNotTargetted();
        BindingImpl base = this.getBinding();
        this.setBinding(new LinkedBindingImpl<T>(base.getSource(), base.getKey(), base.getScoping(), linkedKey));
        return this;
    }

    @Override
    public void toInstance(T instance) {
        Set<InjectionPoint> injectionPoints;
        this.checkNotTargetted();
        if (instance != null) {
            try {
                injectionPoints = InjectionPoint.forInstanceMethodsAndFields(instance.getClass());
            }
            catch (ConfigurationException e) {
                for (Message message : e.getErrorMessages()) {
                    this.binder.addError(message);
                }
                injectionPoints = Collections.unmodifiableSet(new HashSet((Collection)e.getPartialValue()));
            }
        } else {
            this.binder.addError("Binding to null instances is not allowed. Use toProvider(Providers.of(null)) if this is your intended behaviour.", new Object[0]);
            injectionPoints = Collections.emptySet();
        }
        BindingImpl base = this.getBinding();
        this.setBinding(new InstanceBindingImpl(base.getSource(), base.getKey(), base.getScoping(), injectionPoints, instance));
    }

    @Override
    public BindingBuilder<T> toSupplier(Supplier<? extends T> provider) {
        Set<InjectionPoint> injectionPoints;
        Objects.requireNonNull(provider, "provider");
        this.checkNotTargetted();
        try {
            injectionPoints = InjectionPoint.forInstanceMethodsAndFields(provider.getClass());
        }
        catch (ConfigurationException e) {
            for (Message message : e.getErrorMessages()) {
                this.binder.addError(message);
            }
            injectionPoints = Collections.unmodifiableSet(new HashSet((Collection)e.getPartialValue()));
        }
        BindingImpl base = this.getBinding();
        this.setBinding(new ProviderInstanceBindingImpl<T>(base.getSource(), base.getKey(), base.getScoping(), injectionPoints, provider));
        return this;
    }

    public String toString() {
        return "BindingBuilder<" + String.valueOf(this.getBinding().getKey().getTypeLiteral()) + ">";
    }
}

