/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject.internal;

import io.skylite.core.common.inject.Binding;
import io.skylite.core.common.inject.Injector;
import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.internal.InternalFactory;
import io.skylite.core.common.inject.internal.Scoping;
import io.skylite.core.common.inject.internal.ToStringBuilder;
import io.skylite.core.common.inject.spi.ElementVisitor;
import io.skylite.core.common.inject.spi.InstanceBinding;
import java.util.function.Supplier;

public abstract class BindingImpl<T>
implements Binding<T> {
    private final Injector injector;
    private final Key<T> key;
    private final Object source;
    private final Scoping scoping;
    private final InternalFactory<? extends T> internalFactory;
    private volatile Supplier<T> supplier;

    public BindingImpl(Injector injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory, Scoping scoping) {
        this.injector = injector;
        this.key = key;
        this.source = source;
        this.internalFactory = internalFactory;
        this.scoping = scoping;
    }

    protected BindingImpl(Object source, Key<T> key, Scoping scoping) {
        this.internalFactory = null;
        this.injector = null;
        this.source = source;
        this.key = key;
        this.scoping = scoping;
    }

    @Override
    public Key<T> getKey() {
        return this.key;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public Supplier<T> getSupplier() {
        if (this.supplier == null) {
            if (this.injector == null) {
                throw new UnsupportedOperationException("getProvider() not supported for module bindings");
            }
            this.supplier = this.injector.getSupplier(this.key);
        }
        return this.supplier;
    }

    public InternalFactory<? extends T> getInternalFactory() {
        return this.internalFactory;
    }

    public Scoping getScoping() {
        return this.scoping;
    }

    public boolean isConstant() {
        return this instanceof InstanceBinding;
    }

    public <V> V acceptVisitor(ElementVisitor<V> visitor) {
        return visitor.visit(this);
    }

    protected BindingImpl<T> withScoping(Scoping scoping) {
        throw new AssertionError();
    }

    public String toString() {
        return new ToStringBuilder(Binding.class).add("key", this.key).add("scope", this.scoping).add("source", this.source).toString();
    }

    public Injector getInjector() {
        return this.injector;
    }
}

