/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject.internal;

import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.ErrorsException;
import java.util.concurrent.ConcurrentHashMap;

public abstract class FailableCache<K, V> {
    private final ConcurrentHashMap<K, Object> cache = new ConcurrentHashMap();

    protected abstract V create(K var1, Errors var2) throws ErrorsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Errors errors) throws ErrorsException {
        Object resultOrError = this.cache.get(key);
        if (resultOrError == null) {
            FailableCache failableCache = this;
            synchronized (failableCache) {
                resultOrError = this.load(key);
                this.cache.putIfAbsent(key, resultOrError);
            }
        }
        if (resultOrError instanceof Errors) {
            errors.merge((Errors)resultOrError);
            throw errors.toException();
        }
        Object result = resultOrError;
        return (V)result;
    }

    private Object load(K key) {
        Errors errors = new Errors();
        Object result = null;
        try {
            result = this.create(key, errors);
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
        return errors.hasErrors() ? errors : result;
    }
}

