/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject.internal;

import io.skylite.core.common.inject.Injector;
import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.internal.BindingImpl;
import io.skylite.core.common.inject.internal.InternalFactory;
import io.skylite.core.common.inject.internal.Scoping;
import io.skylite.core.common.inject.internal.ToStringBuilder;
import io.skylite.core.common.inject.spi.BindingTargetVisitor;
import io.skylite.core.common.inject.spi.InjectionPoint;
import io.skylite.core.common.inject.spi.InstanceBinding;
import io.skylite.core.common.inject.util.Suppliers;
import java.util.Set;
import java.util.function.Supplier;

public class InstanceBindingImpl<T>
extends BindingImpl<T>
implements InstanceBinding<T> {
    final T instance;
    final Supplier<T> supplier;
    final Set<InjectionPoint> injectionPoints;

    public InstanceBindingImpl(Injector injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory, Set<InjectionPoint> injectionPoints, T instance) {
        super(injector, key, source, internalFactory, Scoping.UNSCOPED);
        this.injectionPoints = injectionPoints;
        this.instance = instance;
        this.supplier = Suppliers.of(instance);
    }

    public InstanceBindingImpl(Object source, Key<T> key, Scoping scoping, Set<InjectionPoint> injectionPoints, T instance) {
        super(source, key, scoping);
        this.injectionPoints = injectionPoints;
        this.instance = instance;
        this.supplier = Suppliers.of(instance);
    }

    @Override
    public Supplier<T> getSupplier() {
        return this.supplier;
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        return visitor.visit(this);
    }

    @Override
    public T getInstance() {
        return this.instance;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    @Override
    public BindingImpl<T> withScoping(Scoping scoping) {
        return new InstanceBindingImpl(this.getSource(), this.getKey(), scoping, this.injectionPoints, this.instance);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(InstanceBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("instance", this.instance).toString();
    }
}

