/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject.internal;

import io.skylite.core.common.inject.Binder;
import io.skylite.core.common.inject.Exposed;
import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.PrivateBinder;
import io.skylite.core.common.inject.spi.SupplierWithDependencies;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;

public class SupplierMethod<T>
implements SupplierWithDependencies<T> {
    private final Key<T> key;
    private final Class<? extends Annotation> scopeAnnotation;
    private final Object instance;
    private final Method method;
    private final List<Supplier<?>> parameterSuppliers;
    private final boolean exposed;

    SupplierMethod(Key<T> key, Method method, Object instance, List<Supplier<?>> parameterSuppliers, Class<? extends Annotation> scopeAnnotation) {
        this.key = key;
        this.scopeAnnotation = scopeAnnotation;
        this.instance = instance;
        this.method = method;
        this.parameterSuppliers = parameterSuppliers;
        this.exposed = method.getAnnotation(Exposed.class) != null;
    }

    public void configure(Binder binder) {
        binder = binder.withSource(this.method);
        if (this.scopeAnnotation != null) {
            binder.bind(this.key).toSupplier(this).in(this.scopeAnnotation);
        } else {
            binder.bind(this.key).toSupplier(this);
        }
        if (this.exposed) {
            ((PrivateBinder)binder).expose(this.key);
        }
    }

    @Override
    public T get() {
        Object[] parameters = new Object[this.parameterSuppliers.size()];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.parameterSuppliers.get(i).get();
        }
        try {
            Object result = this.method.invoke(this.instance, parameters);
            return (T)result;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

