/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject.internal;

import io.skylite.core.common.inject.Binder;
import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.Module;
import io.skylite.core.common.inject.Supplies;
import io.skylite.core.common.inject.TypeLiteral;
import io.skylite.core.common.inject.internal.Annotations;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.SupplierMethod;
import io.skylite.core.common.inject.spi.Message;
import io.skylite.core.common.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class SupplierMethodsModule
implements Module {
    private final Object delegate;
    private final TypeLiteral<?> typeLiteral;

    private SupplierMethodsModule(Object delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.typeLiteral = TypeLiteral.get(this.delegate.getClass());
    }

    public static Module forModule(Module module) {
        return SupplierMethodsModule.forObject(module);
    }

    public static Module forObject(Object object) {
        if (object instanceof SupplierMethodsModule) {
            return Modules.EMPTY_MODULE;
        }
        return new SupplierMethodsModule(object);
    }

    @Override
    public synchronized void configure(Binder binder) {
        for (SupplierMethod<?> providerMethod : this.getProviderMethods(binder)) {
            providerMethod.configure(binder);
        }
    }

    public List<SupplierMethod<?>> getProviderMethods(Binder binder) {
        ArrayList result = new ArrayList();
        for (Class<?> c = this.delegate.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Method method : c.getMethods()) {
                if (method.getAnnotation(Supplies.class) == null) continue;
                result.add(this.createSupplierMethod(binder, method));
            }
        }
        return result;
    }

    <T> SupplierMethod<T> createSupplierMethod(Binder binder, Method method) {
        Key<?> key;
        binder = binder.withSource(method);
        Errors errors = new Errors(method);
        ArrayList parameterSuppliers = new ArrayList();
        List<TypeLiteral<?>> parameterTypes = this.typeLiteral.getParameterTypes(method);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            key = this.getKey(errors, parameterTypes.get(i), method, parameterAnnotations[i]);
            parameterSuppliers.add(binder.getSupplier(key));
        }
        TypeLiteral<?> returnType = this.typeLiteral.getReturnType(method);
        key = this.getKey(errors, returnType, method, method.getAnnotations());
        Class<? extends Annotation> scopeAnnotation = Annotations.findScopeAnnotation(errors, method.getAnnotations());
        for (Message message : errors.getMessages()) {
            binder.addError(message);
        }
        return new SupplierMethod(key, method, this.delegate, parameterSuppliers, scopeAnnotation);
    }

    <T> Key<T> getKey(Errors errors, TypeLiteral<T> type, Member member, Annotation[] annotations) {
        Annotation bindingAnnotation = Annotations.findBindingAnnotation(errors, member, annotations);
        return bindingAnnotation == null ? Key.get(type) : Key.get(type, bindingAnnotation);
    }

    public boolean equals(Object o) {
        return o instanceof SupplierMethodsModule && ((SupplierMethodsModule)o).delegate == this.delegate;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

