/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject.multibindings;

import io.skylite.core.common.inject.Binder;
import io.skylite.core.common.inject.Binding;
import io.skylite.core.common.inject.ConfigurationException;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.inject.Injector;
import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.Module;
import io.skylite.core.common.inject.TypeLiteral;
import io.skylite.core.common.inject.binder.LinkedBindingBuilder;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.multibindings.Element;
import io.skylite.core.common.inject.multibindings.RealElement;
import io.skylite.core.common.inject.spi.Message;
import io.skylite.core.common.inject.util.Types;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public abstract class Multibinder<T> {
    private Multibinder() {
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> type) {
        binder = binder.skipSources(RealMultibinder.class, Multibinder.class);
        RealMultibinder<T> result = new RealMultibinder<T>(binder, type, Key.get(Multibinder.setOf(type)));
        binder.install(result);
        return result;
    }

    private static <T> TypeLiteral<Set<T>> setOf(TypeLiteral<T> elementType) {
        ParameterizedType type = Types.setOf(elementType.getType());
        return TypeLiteral.get(type);
    }

    static void checkConfiguration(boolean condition, String format, Object ... args) {
        if (condition) {
            return;
        }
        throw new ConfigurationException(Collections.singleton(new Message(Errors.format(format, args))));
    }

    static <T> T checkNotNull(T reference, String name) {
        if (reference != null) {
            return reference;
        }
        NullPointerException npe = new NullPointerException(name);
        throw new ConfigurationException(Collections.singleton(new Message(Collections.emptyList(), npe)));
    }

    public static final class RealMultibinder<T>
    extends Multibinder<T>
    implements Module,
    Supplier<Set<T>> {
        private final TypeLiteral<T> elementType;
        private final Key<Set<T>> setKey;
        private Binder binder;
        private List<Supplier<T>> suppliers;

        private RealMultibinder(Binder binder, TypeLiteral<T> elementType, Key<Set<T>> setKey) {
            this.binder = Objects.requireNonNull(binder, "binder");
            this.elementType = Objects.requireNonNull(elementType, "elementType");
            this.setKey = Objects.requireNonNull(setKey, "setKey");
        }

        @Override
        public void configure(Binder binder) {
            RealMultibinder.checkConfiguration(!this.isInitialized(), "Multibinder was already initialized", new Object[0]);
            binder.bind(this.setKey).toSupplier(this);
        }

        public LinkedBindingBuilder<T> addBinding() {
            RealMultibinder.checkConfiguration(!this.isInitialized(), "Multibinder was already initialized", new Object[0]);
            return this.binder.bind(Key.get(this.elementType, new RealElement("")));
        }

        @Inject
        public void initialize(Injector injector) {
            this.suppliers = new ArrayList<Supplier<T>>();
            for (Binding<T> entry : injector.findBindingsByType(this.elementType)) {
                Key<T> key = entry.getKey();
                if (!key.getTypeLiteral().equals(this.elementType) || !(key.getAnnotation() instanceof Element) || !((Element)key.getAnnotation()).setName().equals("")) continue;
                Binding<T> binding = entry;
                this.suppliers.add(binding.getSupplier());
            }
            this.binder = null;
        }

        private boolean isInitialized() {
            return this.binder == null;
        }

        @Override
        public Set<T> get() {
            RealMultibinder.checkConfiguration(this.isInitialized(), "Multibinder is not initialized", new Object[0]);
            LinkedHashSet<T> result = new LinkedHashSet<T>();
            for (Supplier<T> supplier : this.suppliers) {
                T newValue = supplier.get();
                RealMultibinder.checkConfiguration(newValue != null, "Set injection failed due to null element", new Object[0]);
                RealMultibinder.checkConfiguration(result.add(newValue), "Set injection failed due to duplicated element \"%s\"", newValue);
            }
            return Collections.unmodifiableSet(result);
        }

        String getSetName() {
            return "";
        }

        Key<Set<T>> getSetKey() {
            return this.setKey;
        }

        public boolean equals(Object o) {
            return o instanceof RealMultibinder && ((RealMultibinder)o).setKey.equals(this.setKey);
        }

        public int hashCode() {
            return this.setKey.hashCode();
        }

        public String toString() {
            return "Multibinder<" + this.elementType + ">";
        }
    }
}

