/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject.spi;

import io.skylite.core.common.inject.AbstractModule;
import io.skylite.core.common.inject.Binder;
import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.Module;
import io.skylite.core.common.inject.PrivateBinder;
import io.skylite.core.common.inject.Scope;
import io.skylite.core.common.inject.Stage;
import io.skylite.core.common.inject.TypeLiteral;
import io.skylite.core.common.inject.binder.AnnotatedBindingBuilder;
import io.skylite.core.common.inject.internal.AbstractBindingBuilder;
import io.skylite.core.common.inject.internal.BindingBuilder;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.SourceProvider;
import io.skylite.core.common.inject.internal.SupplierMethodsModule;
import io.skylite.core.common.inject.spi.Element;
import io.skylite.core.common.inject.spi.Message;
import io.skylite.core.common.inject.spi.ScopeBinding;
import io.skylite.core.common.inject.spi.SupplierLookup;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Elements {
    public static List<Element> getElements(Module ... modules) {
        return Elements.getElements(Stage.DEVELOPMENT, Arrays.asList(modules));
    }

    public static List<Element> getElements(Stage stage, Iterable<? extends Module> modules) {
        RecordingBinder binder = new RecordingBinder(stage);
        for (Module module : modules) {
            binder.install(module);
        }
        return Collections.unmodifiableList(binder.elements);
    }

    private static class RecordingBinder
    implements Binder,
    PrivateBinder {
        private final Stage stage;
        private final Set<Module> modules;
        private final List<Element> elements;
        private final Object source;
        private final SourceProvider sourceProvider;
        private final RecordingBinder parent;
        private static final Logger logger = LogManager.getLogger(Elements.class);

        private RecordingBinder(Stage stage) {
            this.stage = stage;
            this.modules = new HashSet<Module>();
            this.elements = new ArrayList<Element>();
            this.source = null;
            this.sourceProvider = new SourceProvider().plusSkippedClasses(Elements.class, RecordingBinder.class, AbstractModule.class, AbstractBindingBuilder.class, BindingBuilder.class);
            this.parent = null;
        }

        private RecordingBinder(RecordingBinder prototype, Object source, SourceProvider sourceProvider) {
            if (!(source == null ^ sourceProvider == null)) {
                throw new IllegalArgumentException();
            }
            this.stage = prototype.stage;
            this.modules = prototype.modules;
            this.elements = prototype.elements;
            this.source = source;
            this.sourceProvider = sourceProvider;
            this.parent = prototype.parent;
        }

        @Override
        public void bindScope(Class<? extends Annotation> annotationType, Scope scope) {
            this.elements.add(new ScopeBinding(this.getSource(), annotationType, scope));
        }

        @Override
        public void install(Module module) {
            if (this.modules.add(module)) {
                RecordingBinder binder = this;
                try {
                    module.configure(binder);
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    Collection<Message> messages = Errors.getMessagesFromThrowable(e);
                    if (!messages.isEmpty()) {
                        this.elements.addAll(messages);
                    }
                    this.addError(e);
                }
                binder.install(SupplierMethodsModule.forModule(module));
            }
        }

        @Override
        public void addError(String message, Object ... arguments) {
            this.elements.add(new Message(this.getSource(), Errors.format(message, arguments)));
        }

        @Override
        public void addError(Throwable t) {
            String message = "An exception was caught and reported. Message: " + t.getMessage();
            this.elements.add(new Message(Collections.singletonList(this.getSource()), message, t));
        }

        @Override
        public void addError(Message message) {
            this.elements.add(message);
        }

        public <T> AnnotatedBindingBuilder<T> bind(Key<T> key) {
            return new BindingBuilder<T>(this, this.elements, this.getSource(), key);
        }

        @Override
        public <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
            return this.bind((Key)Key.get(typeLiteral));
        }

        @Override
        public <T> AnnotatedBindingBuilder<T> bind(Class<T> type) {
            return this.bind((Key)Key.get(type));
        }

        @Override
        public <T> Supplier<T> getSupplier(Key<T> key) {
            SupplierLookup<T> element = new SupplierLookup<T>(this.getSource(), key);
            this.elements.add(element);
            return element.getSupplier();
        }

        @Override
        public RecordingBinder withSource(Object source) {
            return new RecordingBinder(this, source, null);
        }

        @Override
        public RecordingBinder skipSources(Class ... classesToSkip) {
            if (this.source != null) {
                return this;
            }
            SourceProvider newSourceProvider = this.sourceProvider.plusSkippedClasses(classesToSkip);
            return new RecordingBinder(this, null, newSourceProvider);
        }

        @Override
        public void expose(Key<?> key) {
            this.addError("Cannot expose %s on a standard binder. Exposed bindings are only applicable to private binders.", key);
        }

        protected Object getSource() {
            Object ret = logger.isDebugEnabled() ? (this.sourceProvider != null ? this.sourceProvider.get() : this.source) : this.source;
            return ret == null ? "_unknown_" : ret;
        }

        public String toString() {
            return "Binder";
        }
    }
}

