/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.io;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.skylite.SkyliteException;
import io.skylite.core.common.Strings;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;

public class Base64Helper {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private Base64Helper() {
    }

    public static String serializeObject(Serializable object) {
        assert (object != null);
        try {
            String json = OBJECT_MAPPER.writeValueAsString((Object)object);
            return Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
        }
        catch (JsonProcessingException e) {
            throw new SkyliteException("Instance {} of class {} is not serializable", (Throwable)e, object, object.getClass());
        }
    }

    public static Serializable deserializeObject(String string) {
        assert (!Strings.isNullOrEmpty(string));
        try {
            byte[] bytes = Base64.getDecoder().decode(string);
            String json = new String(bytes, StandardCharsets.UTF_8);
            return (Serializable)OBJECT_MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (Exception e) {
            throw new SkyliteException(e);
        }
    }
}

