/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.io.stream;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.lucene.store.RateLimiter;

public class StreamLimiter {
    private final Supplier<RateLimiter> rateLimiterSupplier;
    private final Listener listener;
    private int bytesSinceLastRateLimit;

    public StreamLimiter(Supplier<RateLimiter> rateLimiterSupplier, Listener listener) {
        this.rateLimiterSupplier = rateLimiterSupplier;
        this.listener = listener;
    }

    public void maybePause(int bytes) throws IOException {
        this.bytesSinceLastRateLimit += bytes;
        RateLimiter rateLimiter = this.rateLimiterSupplier.get();
        if (rateLimiter != null && (long)this.bytesSinceLastRateLimit >= rateLimiter.getMinPauseCheckBytes()) {
            long pause = rateLimiter.pause((long)this.bytesSinceLastRateLimit);
            this.bytesSinceLastRateLimit = 0;
            if (pause > 0L) {
                this.listener.onPause(pause);
            }
        }
    }

    public static interface Listener {
        public void onPause(long var1);
    }
}

