/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.io.stream;

import io.skylite.Version;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public interface Writeable {
    public void writeTo(StreamOutput var1) throws IOException;

    /*
     * Enabled aggressive exception aggregation
     */
    public static <Request> Request recreateObject(Writeable writeable, Reader<Request> reader) {
        try (BytesStreamOutput out = new BytesStreamOutput();){
            Request Request2;
            block13: {
                out.setVersion(Version.CURRENT);
                writeable.writeTo(out);
                StreamInput in = out.bytes().streamInput();
                try {
                    in.setVersion(Version.CURRENT);
                    Request2 = reader.read(in);
                    if (in == null) break block13;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return Request2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @FunctionalInterface
    public static interface Reader<V> {
        public V read(StreamInput var1) throws IOException;
    }

    @FunctionalInterface
    public static interface Writer<V> {
        public void write(StreamOutput var1, V var2) throws IOException;
    }

    public static class WriteableRegistry {
        private static final Map<Class<?>, Writer<?>> WRITER_REGISTRY = new ConcurrentHashMap();
        private static final Map<Class<?>, Class<?>> WRITER_CUSTOM_CLASS_MAP = new ConcurrentHashMap();
        private static final Map<Byte, Reader<?>> LEGACY_READER_REGISTRY = new ConcurrentHashMap();
        private static final Map<String, Reader<?>> READER_REGISTRY = new ConcurrentHashMap();

        public static <W extends Writer<?>> void registerWriter(Class<?> clazz, W writer) {
            if (WRITER_REGISTRY.putIfAbsent(clazz, writer) != null) {
                throw new IllegalArgumentException("Streamable writer already registered for type [" + clazz.getName() + "]");
            }
        }

        public static <R extends Reader<?>> void legacyRegisterReader(byte ordinal, R reader) {
            if (LEGACY_READER_REGISTRY.putIfAbsent(ordinal, reader) != null) {
                throw new IllegalArgumentException("Streamable reader already registered for ordinal [" + ordinal + "]");
            }
        }

        public static <R extends Reader<?>> void registerReader(String fqn, R reader) {
            if (READER_REGISTRY.putIfAbsent(fqn, reader) != null) {
                throw new IllegalArgumentException("Streamable reader already registered for class [" + fqn + "]");
            }
        }

        public static void registerClassAlias(Class<?> classInstance, Class<?> classGeneric) {
            if (WRITER_CUSTOM_CLASS_MAP.putIfAbsent(classInstance, classGeneric) != null) {
                throw new IllegalArgumentException("Streamable custom class already registered [" + String.valueOf(classInstance.getClass()) + "]");
            }
        }

        public static <W extends Writer<?>> W getWriter(Class<?> clazz) {
            return (W)WRITER_REGISTRY.get(clazz);
        }

        public static <R extends Reader<?>> R getReader(byte b) {
            return (R)LEGACY_READER_REGISTRY.get(b);
        }

        public static Class<?> getCustomClassFromInstance(Object value) {
            if (value == null) {
                throw new IllegalArgumentException("Attempting to retrieve a class type from a null value");
            }
            for (Class<?> clazz : WRITER_CUSTOM_CLASS_MAP.values()) {
                if (!clazz.isInstance(value)) continue;
                return clazz;
            }
            return null;
        }
    }
}

