/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.logging;

import io.skylite.core.common.logging.HeaderWarning;
import io.skylite.core.common.logging.SkyliteLogMessage;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.message.Message;

@Plugin(name="HeaderWarningAppender", category="Core", elementType="appender")
public class HeaderWarningAppender
extends AbstractAppender {
    public HeaderWarningAppender(String name, Filter filter) {
        super(name, filter, null);
    }

    public void append(LogEvent event) {
        Message message = event.getMessage();
        if (message instanceof SkyliteLogMessage) {
            SkyliteLogMessage skyliteLogMessage = (SkyliteLogMessage)message;
            String messagePattern = skyliteLogMessage.getMessagePattern();
            Object[] arguments = skyliteLogMessage.getArguments();
            HeaderWarning.addWarning(messagePattern, arguments);
        } else {
            String formattedMessage = event.getMessage().getFormattedMessage();
            HeaderWarning.addWarning(formattedMessage, new Object[0]);
        }
    }

    @PluginFactory
    public static HeaderWarningAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="filter") Filter filter) {
        return new HeaderWarningAppender(name, filter);
    }
}

