/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.metrics;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class OperationStats
implements Writeable,
ToXContentFragment {
    private final long count;
    private final long totalTimeInMillis;
    private final long current;
    private final long failedCount;

    public OperationStats(long count, long totalTimeInMillis, long current, long failedCount) {
        this.count = count;
        this.totalTimeInMillis = totalTimeInMillis;
        this.current = current;
        this.failedCount = failedCount;
    }

    public OperationStats(StreamInput in) throws IOException {
        this.count = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
        this.current = in.readVLong();
        this.failedCount = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        out.writeVLong(this.totalTimeInMillis);
        out.writeVLong(this.current);
        out.writeVLong(this.failedCount);
    }

    public long getCount() {
        return this.count;
    }

    public long getTotalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getFailedCount() {
        return this.failedCount;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field("count", this.count).humanReadableField("time_in_millis", "time", new TimeValue(this.totalTimeInMillis, TimeUnit.MILLISECONDS)).field("current", this.current).field("failed", this.failedCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationStats that = (OperationStats)o;
        return Objects.equals(this.count, that.count) && Objects.equals(this.totalTimeInMillis, that.totalTimeInMillis) && Objects.equals(this.failedCount, that.failedCount) && Objects.equals(this.current, that.current);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.totalTimeInMillis, this.failedCount, this.current);
    }
}

