/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.network;

import io.skylite.common.action.ActionFuture;
import io.skylite.common.action.ActionListener;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.action.support.PlainActionFuture;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;

public interface CloseableChannel
extends Closeable {
    @Override
    public void close();

    public void addCloseListener(ActionListener<Void> var1);

    public boolean isOpen();

    public static <C extends CloseableChannel> void closeChannel(C channel) {
        CloseableChannel.closeChannel(channel, false);
    }

    public static <C extends CloseableChannel> void closeChannel(C channel, boolean blocking) {
        CloseableChannel.closeChannels(Collections.singletonList(channel), blocking);
    }

    public static <C extends CloseableChannel> void closeChannels(List<C> channels, boolean blocking) {
        try {
            IOUtils.close(channels);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        if (blocking) {
            ArrayList<ActionFuture<Void>> futures = new ArrayList<ActionFuture<Void>>(channels.size());
            for (CloseableChannel channel : channels) {
                PlainActionFuture<Void> closeFuture = PlainActionFuture.newFuture();
                channel.addCloseListener(closeFuture);
                futures.add(closeFuture);
            }
            CloseableChannel.blockOnFutures(futures);
        }
    }

    public static void blockOnFutures(List<ActionFuture<Void>> futures) {
        for (ActionFuture<Void> future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException executionException) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

