/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.time;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.core.FeatureFlags;
import io.skylite.core.common.Strings;
import io.skylite.core.common.time.DateFormatters;
import io.skylite.core.common.time.DateMathParser;
import io.skylite.core.common.time.JavaDateFormatter;
import io.skylite.core.common.time.LegacyFormatNames;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public sealed interface DateFormatter
permits JavaDateFormatter {
    @Deprecated
    public static final DateFormatter LEGACY_DEFAULT_DATE_TIME_FORMATTER = DateFormatter.forPattern("strict_date_optional_time||epoch_millis");
    public static final DateFormatter DEFAULT_DATE_TIME_FORMATTER = DateFormatter.forPattern("strict_date_time_no_millis||strict_date_optional_time||epoch_millis", "strict_date_optional_time");

    public static DateFormatter getDefaultDateTimeFormatter() {
        return FeatureFlags.isEnabled(FeatureFlags.DATETIME_FORMATTER_CACHING_SETTING) ? DEFAULT_DATE_TIME_FORMATTER : LEGACY_DEFAULT_DATE_TIME_FORMATTER;
    }

    public static DateFormatter parseDateTimeFormatter(Object node) {
        if (node instanceof String) {
            return DateFormatter.forPattern((String)node);
        }
        throw new IllegalArgumentException("Invalid format: [" + node.toString() + "]: expected string value");
    }

    public TemporalAccessor parse(String var1);

    default public long parseMillis(String input) {
        return DateFormatters.from(this.parse(input)).toInstant().toEpochMilli();
    }

    public DateFormatter withZone(ZoneId var1);

    public DateFormatter withLocale(Locale var1);

    public String format(TemporalAccessor var1);

    default public String formatMillis(long millis) {
        ZoneId zone = this.zone() != null ? this.zone() : ZoneOffset.UTC;
        return this.format(Instant.ofEpochMilli(millis).atZone(zone));
    }

    public String pattern();

    public String printPattern();

    public Locale locale();

    public ZoneId zone();

    public DateMathParser toDateMathParser();

    public static DateFormatter forPattern(String input, String printPattern, Boolean canCacheFormatter, Version supportedVersion) {
        if (!Strings.hasLength(input)) {
            throw new IllegalArgumentException("No date pattern provided");
        }
        String format = DateFormatter.strip8Prefix(input);
        List<String> patterns = DateFormatter.splitCombinedPatterns(format);
        List<DateFormatter> formatters = patterns.stream().map(p -> {
            if (supportedVersion.before(OpenSearchVersion.V_2_12_0)) {
                return LegacyFormatNames.camelCaseToSnakeCase(p);
            }
            return p;
        }).map(DateFormatters::forPattern).collect(Collectors.toList());
        DateFormatter printFormatter = (DateFormatter)formatters.get(0);
        if (Strings.hasLength(printPattern)) {
            String printFormat = DateFormatter.strip8Prefix(printPattern);
            try {
                printFormatter = DateFormatters.forPattern(printFormat);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid print format: " + e.getMessage(), e);
            }
        }
        return JavaDateFormatter.combined(input, formatters, printFormatter, canCacheFormatter);
    }

    public static DateFormatter forPattern(String input) {
        return DateFormatter.forPattern(input, null, false, Version.CURRENT);
    }

    public static DateFormatter forPattern(String input, Version version) {
        return DateFormatter.forPattern(input, null, false, version);
    }

    public static DateFormatter forPattern(String input, String printPattern) {
        return DateFormatter.forPattern(input, printPattern, false, Version.CURRENT);
    }

    public static DateFormatter forPattern(String input, Boolean canCacheFormatter) {
        return DateFormatter.forPattern(input, null, canCacheFormatter, Version.CURRENT);
    }

    public static String strip8Prefix(String input) {
        if (input.startsWith("8")) {
            return input.substring(1);
        }
        return input;
    }

    public static List<String> splitCombinedPatterns(String input) {
        ArrayList<String> patterns = new ArrayList<String>();
        for (String pattern : Strings.delimitedListToStringArray(input, "||")) {
            if (!Strings.hasLength(pattern)) {
                throw new IllegalArgumentException("Cannot have empty element in multi date format pattern: " + input);
            }
            patterns.add(pattern);
        }
        return patterns;
    }
}

